/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.storage.extras;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PixelExtrasDisplayPacket;
import com.pixelmonmod.pixelmon.storage.extras.ExtrasContact;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class PixelExtrasStorage {
    public static final Map<UUID, PixelExtrasData> playerExtras = new HashMap<UUID, PixelExtrasData>();

    public static PixelExtrasData getData(UUID uuid) {
        if (!playerExtras.containsKey(uuid)) {
            playerExtras.put(uuid, new PixelExtrasData(uuid));
            ExtrasContact.fromCache(playerExtras.get(uuid));
        }
        return playerExtras.get(uuid);
    }

    public static void addAndDistribute(PixelExtrasData data) {
        playerExtras.put(data.id, data);
        if (data.isReady() && data.hasData()) {
            Pixelmon.network.sendToAll((IMessage)new PixelExtrasDisplayPacket(data));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        playerExtras.remove(event.player.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (PixelExtrasStorage.getData(player.func_110124_au()).has(ExtrasContact.Groups.Developer)) {
            ChatHandler.sendMessageToAllPlayers(player.func_184102_h(), "" + TextFormatting.AQUA + "\u2605" + I18n.func_74838_a((String)"pixelmon.dev.name") + "\u2605 " + TextFormatting.UNDERLINE + player.func_145748_c_().func_150260_c() + TextFormatting.AQUA + " " + I18n.func_74838_a((String)"pixelmon.dev.join"));
        }
    }
}

