/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.tickHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.IHatchEggs;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.TransientData;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.entity.player.EntityPlayerMP;

public class WalkingEggHatcher
implements IHatchEggs {
    @Override
    public void tick(EntityPlayerMP player, PlayerPartyStorage party) {
        ++party.transientData.eggTick;
        if (party.transientData.eggTick >= 20) {
            party.transientData.eggTick = 0;
            this.doWalkHatching(player, party);
        }
    }

    public int doWalkHatching(EntityPlayerMP player, PlayerPartyStorage party) {
        if (party.countEggs() < 1) {
            return 0;
        }
        TransientData td = party.transientData;
        int posX = player.func_180425_c().func_177958_n();
        int posZ = player.func_180425_c().func_177952_p();
        int changeX = td.lastEggX - posX;
        int changeZ = td.lastEggZ - posZ;
        td.lastEggX = posX;
        td.lastEggZ = posZ;
        if (changeX == -posX && changeZ == -posZ) {
            return 0;
        }
        int steps = Math.abs(changeX) + Math.abs(changeZ);
        if (steps > 20) {
            return 0;
        }
        if (steps == 0) {
            return 0;
        }
        int hatchBonus = this.getHatchBonus(party);
        for (Pokemon pokemon : party.getAll()) {
            if (pokemon == null || !pokemon.isEgg()) continue;
            pokemon.addEggSteps(steps, hatchBonus);
        }
        return steps;
    }
}

