/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.AI;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.Random;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class AISwimming
extends EntityAIBase {
    private EntityPixelmon pixelmon;
    private float swimSpeed = 1.5f;
    private float decayRate = 0.99f;
    private int depthRangeStart = 0;
    private int depthRangeEnd = 100;
    float moveSpeed;
    Random rand;
    int ticksToRefresh;
    boolean lastChangeDirection;
    boolean useLastChangeDirection;

    public AISwimming(EntityPixelmon entity) {
        if (entity.getSwimmingParameters() != null) {
            this.swimSpeed = entity.getSwimmingParameters().swimSpeed;
            this.decayRate = entity.getSwimmingParameters().decayRate;
            this.depthRangeStart = entity.getSwimmingParameters().depthRangeStart;
            this.depthRangeEnd = entity.getSwimmingParameters().depthRangeEnd;
            this.ticksToRefresh = 0;
        }
        this.pixelmon = entity;
        this.rand = entity.func_70681_au();
    }

    public boolean func_75250_a() {
        return this.depthRangeStart != -1;
    }

    public void func_75246_d() {
        if (this.pixelmon.getPokemonName().equals("Magikarp")) {
            this.swimSpeed = 0.7f;
        }
        if (this.pixelmon.battleController != null) {
            super.func_75246_d();
            return;
        }
        if (!this.pixelmon.func_70090_H()) {
            return;
        }
        boolean useLastChangeDirection = false;
        RayTraceResult mop = this.pixelmon.field_70170_p.func_72933_a(new Vec3d(this.pixelmon.field_70165_t, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.field_70161_v), new Vec3d(this.pixelmon.field_70165_t + this.pixelmon.field_70159_w * 100.0, this.pixelmon.func_174813_aQ().field_72338_b, this.pixelmon.field_70161_v + this.pixelmon.field_70179_y * 100.0));
        if (mop == null) {
            mop = this.pixelmon.field_70170_p.func_72933_a(new Vec3d(this.pixelmon.field_70165_t, this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.field_70161_v), new Vec3d(this.pixelmon.field_70165_t + this.pixelmon.field_70159_w * 100.0, this.pixelmon.func_174813_aQ().field_72337_e, this.pixelmon.field_70161_v + this.pixelmon.field_70179_y * 100.0));
        }
        if (mop != null) {
            useLastChangeDirection = true;
        }
        --this.ticksToRefresh;
        if (this.moveSpeed == 0.0f || useLastChangeDirection || this.pixelmon.field_70159_w * this.pixelmon.field_70159_w + this.pixelmon.field_70179_y * this.pixelmon.field_70179_y < (double)(this.moveSpeed / 4.0f)) {
            this.pickDirection(useLastChangeDirection);
            this.pickSpeed();
            this.pixelmon.func_191986_a(0.0f, 0.0f, this.moveSpeed);
        }
        super.func_75246_d();
    }

    public boolean func_75253_b() {
        this.moveSpeed *= this.decayRate;
        this.pixelmon.field_70159_w *= (double)this.decayRate;
        this.pixelmon.field_70181_x *= (double)this.decayRate;
        this.pixelmon.field_70179_y *= (double)this.decayRate;
        this.pixelmon.field_70761_aq = this.pixelmon.field_70177_z;
        return true;
    }

    public void pickDirection(boolean useLastChangeDirection) {
        double rotAmt;
        if (useLastChangeDirection) {
            rotAmt = this.pixelmon.func_70681_au().nextInt(5) + 5;
            if (this.lastChangeDirection) {
                rotAmt *= -1.0;
            }
        } else {
            rotAmt = this.pixelmon.func_70681_au().nextInt(10) - 5;
            this.lastChangeDirection = rotAmt > 0.0;
        }
        this.pixelmon.field_70177_z = (float)((double)this.pixelmon.field_70177_z + rotAmt);
    }

    public void pickSpeed() {
        this.moveSpeed = 2.8f * (this.pixelmon.func_70681_au().nextFloat() * this.swimSpeed + this.swimSpeed / 2.0f);
        int wdepth = WorldHelper.getWaterDepth(this.pixelmon.func_180425_c(), this.pixelmon.field_70170_p);
        this.pixelmon.field_70181_x = wdepth >= this.depthRangeEnd ? (double)((0.02f + this.rand.nextFloat()) * 0.1f) : (wdepth <= this.depthRangeStart ? (double)((-0.02f - this.rand.nextFloat()) * 0.1f) : (double)((this.rand.nextFloat() - 0.5f) * 0.1f));
    }
}

