/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.PixelmonEventHandler;
import com.pixelmonmod.pixelmon.ReforgedPokemonFactory;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccountManager;
import com.pixelmonmod.pixelmon.api.lures.ILureExpirer;
import com.pixelmonmod.pixelmon.api.pokemon.IHatchEggs;
import com.pixelmonmod.pixelmon.api.pokemon.IPassiveEffects;
import com.pixelmonmod.pixelmon.api.pokemon.IPassiveHealer;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.IStorageManager;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.PacketRegistry;
import com.pixelmonmod.pixelmon.commands.BattleCommand;
import com.pixelmonmod.pixelmon.commands.BlockSnapShot;
import com.pixelmonmod.pixelmon.commands.BreedCommand;
import com.pixelmonmod.pixelmon.commands.CheckSpawnsCommand;
import com.pixelmonmod.pixelmon.commands.DebugCommand;
import com.pixelmonmod.pixelmon.commands.DeepStorageCmd;
import com.pixelmonmod.pixelmon.commands.DoLegendarySpawnCommand;
import com.pixelmonmod.pixelmon.commands.DynamaxBandCommand;
import com.pixelmonmod.pixelmon.commands.EndBattleCommand;
import com.pixelmonmod.pixelmon.commands.FillDexCommand;
import com.pixelmonmod.pixelmon.commands.FreezeCommand;
import com.pixelmonmod.pixelmon.commands.GetBiomeData;
import com.pixelmonmod.pixelmon.commands.GivePixelSpriteCommand;
import com.pixelmonmod.pixelmon.commands.HealCommand;
import com.pixelmonmod.pixelmon.commands.MegaRingCommand;
import com.pixelmonmod.pixelmon.commands.OvalCharmCommand;
import com.pixelmonmod.pixelmon.commands.PixelTPCommand;
import com.pixelmonmod.pixelmon.commands.PokeGiveCommand;
import com.pixelmonmod.pixelmon.commands.RanchUnlockCommand;
import com.pixelmonmod.pixelmon.commands.Reload;
import com.pixelmonmod.pixelmon.commands.ReloadMoveAnimations;
import com.pixelmonmod.pixelmon.commands.Save;
import com.pixelmonmod.pixelmon.commands.SetPartyCommand;
import com.pixelmonmod.pixelmon.commands.ShinyCharmCommand;
import com.pixelmonmod.pixelmon.commands.SpawnCommand;
import com.pixelmonmod.pixelmon.commands.SpawningCommand;
import com.pixelmonmod.pixelmon.commands.SpectateCommand;
import com.pixelmonmod.pixelmon.commands.Stats;
import com.pixelmonmod.pixelmon.commands.StatsReset;
import com.pixelmonmod.pixelmon.commands.StrucCommand;
import com.pixelmonmod.pixelmon.commands.TeachCommand;
import com.pixelmonmod.pixelmon.commands.TierShow;
import com.pixelmonmod.pixelmon.commands.WarpPlateCommand;
import com.pixelmonmod.pixelmon.commands.econ.BankTransferCommand;
import com.pixelmonmod.pixelmon.commands.econ.GiveMoneyCommand;
import com.pixelmonmod.pixelmon.commands.quests.CompleteAllQuestsCommand;
import com.pixelmonmod.pixelmon.commands.quests.QuestDataCommand;
import com.pixelmonmod.pixelmon.commands.quests.ReloadQuestsCommand;
import com.pixelmonmod.pixelmon.commands.quests.ResetAllQuestsCommand;
import com.pixelmonmod.pixelmon.commands.quests.SetStageCommand;
import com.pixelmonmod.pixelmon.config.BlockRevealParser;
import com.pixelmonmod.pixelmon.config.FormLogRegistry;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.RemapHandler;
import com.pixelmonmod.pixelmon.listener.PixelmonLootTables;
import com.pixelmonmod.pixelmon.sounds.PixelSounds;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.storage.ReforgedStorageManager;
import com.pixelmonmod.pixelmon.storage.adapters.ReforgedFileAdapter;
import com.pixelmonmod.pixelmon.storage.schedulers.ReforgedStorageAsyncScheduler;
import com.pixelmonmod.pixelmon.storage.schedulers.ReforgedStorageStandardScheduler;
import com.pixelmonmod.pixelmon.tickHandlers.SteadyLureExpirer;
import com.pixelmonmod.pixelmon.tickHandlers.WalkingEggHatcher;
import com.pixelmonmod.pixelmon.tickHandlers.WalkingPassiveEffects;
import com.pixelmonmod.pixelmon.tickHandlers.WalkingPassiveHealer;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.debug.DebugWorldRegistry;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.UltraSpace;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="pixelmon", name="Pixelmon", version="8.1.2", updateJSON="https://reforged.gg/forge/update.json", guiFactory="com.pixelmonmod.pixelmon.client.gui.factory.GuiFactoryPixelmon")
public class Pixelmon {
    public static final String MODID = "pixelmon";
    public static final String NAME = "Pixelmon";
    public static final String VERSION = "8.1.2";
    static final String UPDATE = "https://reforged.gg/forge/update.json";
    public static final EventBus EVENT_BUS = new EventBus();
    public static final Logger LOGGER = LogManager.getLogger((String)"Pixelmon");
    @Mod.Instance(value="pixelmon")
    public static Pixelmon instance;
    @SidedProxy(clientSide="com.pixelmonmod.pixelmon.client.ClientProxy", serverSide="com.pixelmonmod.pixelmon.CommonProxy")
    public static CommonProxy proxy;
    public static boolean freeze;
    public static File modDirectory;
    public static SimpleNetworkWrapper network;
    public static boolean canSendOutPokemon;
    public static boolean devEnvironment;
    public static PixelmonAdvancements ADVANCEMENTS;
    public static IPixelmonBankAccountManager moneyManager;
    public static IStorageManager storageManager;
    public static PokemonFactory<? extends Pokemon> pokemonFactory;
    public static IHatchEggs eggHatcher;
    public static IPassiveHealer passiveHealer;
    public static IPassiveEffects passiveEffects;
    public static ILureExpirer lureExpirer;
    private static PixelmonEventHandler eventHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("Loading Pixelmon version 8.1.2");
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        PacketRegistry.registerPackets();
        PacketRegistry.replaceNetworkCheck();
        modDirectory = new File(event.getModConfigurationDirectory().getParent());
        PixelmonConfig.init(new File("./config/pixelmon.hocon"));
        ADVANCEMENTS = new PixelmonAdvancements();
        PokemonSpec.registerDefaultExtraSpecs();
        eventHandler = new PixelmonEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        EVENT_BUS.register((Object)eventHandler);
        PixelmonLootTables.register();
        proxy.registerKeyBindings();
        proxy.removeDungeonMobs();
        proxy.preInit();
        UltraSpace.register();
        UltraSpace.registerWorldFeatures();
        if (devEnvironment) {
            DebugWorldRegistry.init();
        }
        try {
            AttackBase.loadAllAttacks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pokemonFactory = new ReforgedPokemonFactory();
        ReforgedStorageManager storageManager = new ReforgedStorageManager(PixelmonConfig.useAsyncSaving ? new ReforgedStorageAsyncScheduler() : new ReforgedStorageStandardScheduler(), new ReforgedFileAdapter());
        Pixelmon.storageManager = storageManager;
        storageManager.setSaveAdapter(storageManager.getSaveAdapter());
        storageManager.setSaveScheduler(storageManager.getSaveScheduler());
        MinecraftForge.EVENT_BUS.register((Object)storageManager);
        MinecraftForge.EVENT_BUS.register((Object)storageManager.getSaveScheduler());
        if (Pixelmon.storageManager instanceof IPixelmonBankAccountManager && moneyManager == null) {
            moneyManager = storageManager;
        }
        passiveHealer = new WalkingPassiveHealer();
        eggHatcher = new WalkingEggHatcher();
        passiveEffects = new WalkingPassiveEffects();
        lureExpirer = new SteadyLureExpirer();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerInteractions();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.init();
        proxy.registerRenderers();
        proxy.registerTickHandlers();
        FormLogRegistry.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BlockRevealParser.parse();
        proxy.registerCommands();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        RemapHandler.attemptHackyFixForRipOffPixelmonMappingIssues(event.getServer());
        if (event.getSide() != Side.SERVER && event.getSide() == Side.CLIENT) {
            storageManager.clearAll();
        }
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() != null;
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new GiveMoneyCommand());
        event.registerServerCommand((ICommand)new BankTransferCommand());
        event.registerServerCommand((ICommand)new BattleCommand());
        event.registerServerCommand((ICommand)new BlockSnapShot());
        event.registerServerCommand((ICommand)new BreedCommand());
        event.registerServerCommand((ICommand)new CheckSpawnsCommand());
        event.registerServerCommand((ICommand)new DeepStorageCmd());
        event.registerServerCommand((ICommand)new DoLegendarySpawnCommand());
        event.registerServerCommand((ICommand)new EndBattleCommand());
        event.registerServerCommand((ICommand)new FreezeCommand());
        event.registerServerCommand((ICommand)new HealCommand());
        event.registerServerCommand((ICommand)new MegaRingCommand());
        event.registerServerCommand((ICommand)new DynamaxBandCommand());
        event.registerServerCommand((ICommand)new ShinyCharmCommand());
        event.registerServerCommand((ICommand)new OvalCharmCommand());
        event.registerServerCommand((ICommand)new PokeGiveCommand());
        event.registerServerCommand((ICommand)new SetPartyCommand());
        event.registerServerCommand((ICommand)new SpawnCommand());
        event.registerServerCommand((ICommand)new SpawningCommand());
        event.registerServerCommand((ICommand)new SpectateCommand());
        event.registerServerCommand((ICommand)new Stats());
        event.registerServerCommand((ICommand)new StatsReset());
        event.registerServerCommand((ICommand)new StrucCommand());
        event.registerServerCommand((ICommand)new TeachCommand());
        event.registerServerCommand((ICommand)new TierShow());
        event.registerServerCommand((ICommand)new RanchUnlockCommand());
        event.registerServerCommand((ICommand)new WarpPlateCommand());
        event.registerServerCommand((ICommand)new GivePixelSpriteCommand());
        event.registerServerCommand((ICommand)new Save());
        event.registerServerCommand((ICommand)new Reload());
        event.registerServerCommand((ICommand)new ReloadMoveAnimations());
        event.registerServerCommand((ICommand)new SetStageCommand());
        event.registerServerCommand((ICommand)new ResetAllQuestsCommand());
        event.registerServerCommand((ICommand)new CompleteAllQuestsCommand());
        event.registerServerCommand((ICommand)new QuestDataCommand());
        event.registerServerCommand((ICommand)new ReloadQuestsCommand());
        if (devEnvironment && event.getSide().isClient()) {
            event.registerServerCommand((ICommand)new DebugCommand());
            event.registerServerCommand((ICommand)new GetBiomeData());
            event.registerServerCommand((ICommand)new PixelTPCommand());
            event.registerServerCommand((ICommand)new FillDexCommand());
        }
        if (PixelmonSpawning.coordinator == null) {
            PixelmonSpawning.startTrackingSpawner();
        }
        PixelSounds.linkPixelmonSounds();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent event) {
        storageManager.getSaveScheduler().onServerStopping(event);
    }

    static {
        freeze = false;
        canSendOutPokemon = true;
        devEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

