/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.item.JsonItemStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumPokerusType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.translation.I18n;

public class SpawnInfoPokemon
extends SpawnInfo {
    public static final String TYPE_ID_POKEMON = "pokemon";
    public transient EnumSpecies species;
    private PokemonSpec spec = PokemonSpec.from("Psyduck");
    public ArrayList<PokemonSpec> specs = null;
    public int minLevel = 1;
    public int maxLevel = 100;
    public Float spawnSpecificShinyRate = null;
    public Float spawnSpecificBossRate = null;
    public Float spawnSpecificPokerusRate = null;
    public ArrayList<JsonItemStack> heldItems = null;

    public SpawnInfoPokemon() {
        super(TYPE_ID_POKEMON);
    }

    @Override
    public void onImport() {
        this.calculateRequiredSpace();
        super.onImport();
        if (this.minLevel > this.maxLevel) {
            Pixelmon.LOGGER.warn("A SpawnInfo for " + this.spec.name + " has minLevel=" + this.minLevel + " and maxLevel=" + this.maxLevel + " which is weird. Fixing.");
            int temp = this.minLevel;
            this.minLevel = this.maxLevel;
            this.maxLevel = temp;
        }
        if (this.heldItems == null || !this.heldItems.isEmpty()) {
            // empty if block
        }
        if (this.spec != null) {
            Pokemon dummyPokemon = this.spec.create();
            if (BetterSpawnerConfig.INSTANCE.autoTagSpecs != null) {
                for (Map.Entry<String, PokemonSpec> entry : BetterSpawnerConfig.INSTANCE.autoTagSpecs.entrySet()) {
                    if (!entry.getValue().matches(dummyPokemon) || this.tags.contains(entry.getKey())) continue;
                    this.tags.add(entry.getKey());
                }
            }
        }
    }

    public void setPokemon(PokemonSpec spec) {
        this.spec = spec;
        this.requiredSpace = -1;
        this.calculateRequiredSpace();
    }

    public void calculateRequiredSpace() {
        if (this.spec.name != null && this.requiredSpace == -1) {
            if (EnumSpecies.hasPokemon(this.spec.name)) {
                BaseStats baseStats = EnumSpecies.getFromNameAnyCaseNoTranslate(this.spec.name).getBaseStats();
                this.requiredSpace = (int)Math.ceil((baseStats.length.floatValue() > baseStats.height.floatValue() ? baseStats.length : baseStats.height).floatValue());
            } else {
                this.requiredSpace = 0;
            }
        }
    }

    public SpawnAction<EntityPixelmon> construct(AbstractSpawner spawner, SpawnLocation spawnLocation) {
        PokemonSpec usingSpec = null;
        PokemonSpec baseSpec = null;
        if (this.spec == null && this.specs != null && this.specs.size() > 0) {
            baseSpec = this.specs.get(RandomHelper.getRandomNumberBetween(0, this.specs.size()));
            usingSpec = baseSpec.copy();
        } else {
            baseSpec = this.spec;
            usingSpec = baseSpec.copy();
        }
        if (usingSpec.name == null) {
            usingSpec.name = EnumSpecies.Psyduck.name;
        } else if (usingSpec.name.equalsIgnoreCase("random")) {
            usingSpec.name = EnumSpecies.randomPoke((boolean)false).name;
        } else if (usingSpec.name.equalsIgnoreCase("randomlegendary")) {
            usingSpec.name = CollectionHelper.getRandomElement(EnumSpecies.legendaries);
        }
        if (usingSpec.level == null) {
            usingSpec.level = RandomHelper.getRandomNumberBetween(Math.min(this.minLevel, PixelmonServerConfig.maxLevel), Math.min(this.maxLevel, PixelmonServerConfig.maxLevel));
        }
        if (usingSpec.shiny == null) {
            if (this.spawnSpecificShinyRate != null) {
                if (this.spawnSpecificShinyRate.floatValue() == 0.0f) {
                    usingSpec.shiny = false;
                } else if (this.spawnSpecificShinyRate.floatValue() > 0.0f) {
                    usingSpec.shiny = RandomHelper.getRandomChance(1.0f / this.spawnSpecificShinyRate.floatValue());
                }
            } else if (this.set.setSpecificShinyRate != null) {
                if (this.set.setSpecificShinyRate.floatValue() == 0.0f) {
                    usingSpec.shiny = false;
                } else if (this.set.setSpecificShinyRate.floatValue() > 0.0f) {
                    usingSpec.shiny = RandomHelper.getRandomChance(1.0f / this.set.setSpecificShinyRate.floatValue());
                }
            } else if (PixelmonConfig.getShinyRate(spawnLocation.location.world.field_73011_w.getDimension()) > 0.0f) {
                float shinyChanceMultiplier = 1.0f;
                if (spawnLocation.cause instanceof EntityPlayerMP) {
                    PlayerPartyStorage party = Pixelmon.storageManager.getParty((EntityPlayerMP)spawnLocation.cause);
                    if (party.getShinyCharm().isActive()) {
                        shinyChanceMultiplier *= 3.0f;
                    }
                    if (party.getLure() != null && party.getLure().type == ItemLure.LureType.SHINY) {
                        shinyChanceMultiplier *= (float)Math.sqrt(party.getLure().strength.multiplier);
                    }
                }
                usingSpec.shiny = RandomHelper.getRandomChance(shinyChanceMultiplier / PixelmonConfig.getShinyRate(spawnLocation.location.world.field_73011_w.getDimension()));
            } else {
                usingSpec.shiny = false;
            }
        }
        if (usingSpec.boss == null) {
            boolean willBeBoss = false;
            if (this.spawnSpecificBossRate != null && this.spawnSpecificBossRate.floatValue() > 0.0f && RandomHelper.getRandomChance(1.0f / this.spawnSpecificBossRate.floatValue())) {
                willBeBoss = true;
            } else if (PixelmonConfig.getBossRate(spawnLocation.location.world.field_73011_w.getDimension()) > 0.0f && RandomHelper.getRandomChance(1.0f / PixelmonConfig.getBossRate(spawnLocation.location.world.field_73011_w.getDimension()))) {
                willBeBoss = true;
            }
            if (willBeBoss) {
                EnumBossMode bossMode = EnumBossMode.Uncommon;
                EnumSpecies species = EnumSpecies.getFromNameAnyCaseNoTranslate(usingSpec.name);
                boolean legendary = EnumSpecies.legendaries.contains(species.name);
                if (species != null) {
                    if (EnumMegaPokemon.getMega(species) != null) {
                        bossMode = legendary ? EnumBossMode.Legendary : EnumBossMode.getRandomModeMega();
                    } else if (legendary) {
                        bossMode = EnumBossMode.Legendary;
                    }
                }
                usingSpec.boss = (byte)bossMode.index;
            }
        }
        if (usingSpec.pokerusType == null && PixelmonConfig.pokerusEnabled) {
            if (this.spawnSpecificPokerusRate != null) {
                if (this.spawnSpecificPokerusRate.floatValue() > 0.0f) {
                    usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / this.spawnSpecificPokerusRate.floatValue()) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
                }
            } else if (this.set.setSpecificPokerusRate != null) {
                if (this.set.setSpecificPokerusRate.floatValue() > 0.0f) {
                    usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / this.set.setSpecificPokerusRate.floatValue()) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
                }
            } else if (PixelmonConfig.pokerusRate > 0.0f) {
                usingSpec.pokerusType = RandomHelper.getRandomChance(1.0f / PixelmonConfig.pokerusRate) ? Byte.valueOf((byte)EnumPokerusType.getRandomType().ordinal()) : null;
            }
        }
        return new SpawnActionPokemon(this, spawnLocation, baseSpec, usingSpec);
    }

    public PokemonSpec getPokemonSpec() {
        return this.spec;
    }

    public EnumSpecies getSpecies() {
        if (this.species == null) {
            this.species = EnumSpecies.getFromNameAnyCase(this.spec.name);
            if (this.species == null) {
                Pixelmon.LOGGER.warn("Bad Pok\u00e9mon name: " + this.spec.name + " in set " + this.set.id);
            }
        }
        return this.species;
    }

    @Override
    public String toString() {
        if (this.spec.name == null || this.spec.name.equals("random")) {
            return "Random";
        }
        return I18n.func_74838_a((String)("pixelmon." + this.spec.name.toLowerCase() + ".name"));
    }
}

