/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.trading.SetClientTradePair;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCTrades {
    public static PokemonSpec UNTRADEABLE;
    private static final HashMap<UUID, TradePair> activeTrades;

    public static void updateClientTradeData(EntityPlayerMP player, TradePair tradePair) {
        boolean hasPokemon = false;
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
        for (Pokemon pokemon : party.getTeam()) {
            if (pokemon == null || !tradePair.exchange.matches(pokemon) || UNTRADEABLE.matches(pokemon)) continue;
            hasPokemon = true;
        }
        Pixelmon.network.sendTo((IMessage)new SetClientTradePair(tradePair, hasPokemon), player);
    }

    public static void showTrade(EntityPlayerMP player, TradePair tradePair) {
        NPCTrades.showTrade(player, tradePair, -1);
    }

    public static void showTrade(EntityPlayerMP player, TradePair tradePair, int trainerID) {
        NPCTrades.updateClientTradeData(player, tradePair);
        activeTrades.put(player.func_110124_au(), tradePair);
        OpenScreen.open((EntityPlayer)player, EnumGuiScreen.NPCTraderGui, trainerID);
    }

    @Nullable
    public static TradePair getTradePair(UUID uuid) {
        return activeTrades.get(uuid);
    }

    public static void clearTradePair(UUID uuid) {
        activeTrades.remove(uuid);
    }

    static {
        activeTrades = new HashMap();
    }
}

