/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;

public class BeatUp
extends SpecialAttackBase {
    private transient boolean inProgress = false;
    private transient int limit = 0;

    @Override
    public AttackResult applyEffectStart(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.limit++ < 6 && this.inProgress) {
            return AttackResult.proceed;
        }
        user.inMultipleHit = true;
        this.inProgress = true;
        this.limit = 0;
        boolean hasSubstitute = false;
        boolean firstHit = true;
        for (PixelmonWrapper p : user.getParticipant().allPokemon) {
            if (!p.isAlive() || p.hasPrimaryStatus()) continue;
            if (!firstHit) {
                user.attack.getMove().setAccuracy(-1);
            }
            hasSubstitute = target.hasStatus(StatusType.Substitute);
            this.doAttack(user, target, p);
            firstHit = false;
        }
        user.inMultipleHit = false;
        this.inProgress = false;
        user.attack.sendEffectiveChat(user, target);
        Attack.postProcessAttackAllHits(user, target, user.attack, user.attack.moveResult.damage, DamageTypeEnum.ATTACK, hasSubstitute);
        if (!hasSubstitute) {
            Attack.applyContactLate(user, target);
        }
        return AttackResult.hit;
    }

    private void doAttack(PixelmonWrapper user, PixelmonWrapper target, PixelmonWrapper currentAttacker) {
        MoveResults[] results;
        user.attack.getMove().setBasePower(currentAttacker.getBaseStats().get(StatsType.Attack) / 10 + 5);
        for (MoveResults result : results = user.useAttackOnly()) {
            user.attack.moveResult.damage += result.damage;
            user.attack.moveResult.fullDamage += result.fullDamage;
        }
    }
}

