/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.battles.attacks.Value;
import com.pixelmonmod.pixelmon.battles.attacks.ValueType;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.Recover;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.ArrayList;

public class Synthesis
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.hasFullHealth()) {
            user.bc.sendToAll("pixelmon.effect.healfailed", user.getNickname());
            return AttackResult.failed;
        }
        if (user.hasStatus(StatusType.HealBlock)) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        double heal = (float)user.getMaxHealth() * this.getHealMultiplier(user);
        user.bc.sendToAll("pixelmon.effect.washealed", user.getNickname());
        user.healEntityBy((int)heal);
        return AttackResult.proceed;
    }

    private float getHealMultiplier(PixelmonWrapper user) {
        Weather weather = user.bc.globalStatusController.getWeather();
        if (weather instanceof Sunny) {
            return 0.6666667f;
        }
        if (weather != null) {
            return 0.25f;
        }
        return 0.5f;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        Recover heal = new Recover(new Value((int)(this.getHealMultiplier(pw) * 100.0f), ValueType.WholeNumber));
        heal.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
    }
}

