/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.StickyHold;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.ItemMemory;
import java.util.ArrayList;

public class CorrosiveGas
extends StatusBase {
    public CorrosiveGas() {
        super(StatusType.CorrosiveGas);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.addStatus(new CorrosiveGas(), target)) {
            user.bc.sendToAll("pixelmon.status.corrosivegas", target.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.getBattleAbility() instanceof StickyHold || pokemon.getHeldItem() instanceof ItemMemory && pokemon.getSpecies() == EnumSpecies.Silvally;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            ItemHeld heldItem = target.getUsableHeldItem();
            if (heldItem == null || heldItem.hasNegativeEffect()) continue;
            userChoice.raiseWeight(15.0f);
        }
    }
}

