/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Terrain;
import com.pixelmonmod.pixelmon.battles.status.Yawn;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.battle.EnumTerrain;
import java.util.List;
import javax.annotation.Nonnull;

public class ElectricTerrain
extends Terrain {
    public ElectricTerrain() {
        super(StatusType.ElectricTerrain, "pixelmon.status.electricterrain", "pixelmon.status.electricterrainend");
    }

    @Override
    public Terrain getNewInstance() {
        return new ElectricTerrain();
    }

    @Override
    @Nonnull
    public EnumTerrain getTerrainType() {
        return EnumTerrain.ELECTRIC;
    }

    @Override
    public int[] modifyPowerAndAccuracyTarget(int power, int accuracy, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (a.isAttack("Rising Voltage")) {
            power = (int)((double)power * 2.0);
        } else if (this.affectsPokemon(user) && a.getType() == EnumType.Electric) {
            power = (int)((double)power * 1.3);
        }
        return new int[]{power, accuracy};
    }

    @Override
    public boolean stopsStatusChange(StatusType t, PixelmonWrapper target, PixelmonWrapper user) {
        if (this.affectsPokemon(target) && (t == StatusType.Sleep || t == StatusType.Yawn)) {
            if (user != target && user.attack.getAttackCategory() == AttackCategory.STATUS) {
                target.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            }
            return true;
        }
        return false;
    }

    @Override
    protected int countBenefits(PixelmonWrapper user, PixelmonWrapper target) {
        int benefits = 0;
        if (this.affectsPokemon(target)) {
            List<Attack> moveset = user.getBattleAI().getMoveset(target);
            if (Attack.hasOffensiveAttackType(moveset, EnumType.Electric)) {
                ++benefits;
            }
            if (target.hasStatus(StatusType.Yawn)) {
                ++benefits;
            }
            if (Attack.hasAttack(moveset, "Rest")) {
                --benefits;
            }
            block0: for (Attack move : moveset) {
                for (EffectBase e : move.getMove().effects) {
                    if (!(e instanceof Sleep) && !(e instanceof Yawn)) continue;
                    --benefits;
                    continue block0;
                }
            }
        }
        return benefits;
    }
}

