/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Guts;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Synchronize;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;

public class Paralysis
extends StatusPersist {
    public Paralysis() {
        super(StatusType.Paralysis);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Paralysis.paralyze(user, target, user.attack, true);
        }
    }

    public static boolean paralyze(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        return new Paralysis().addStatus(user, target, attack, showMessage, "pixelmon.effect.alreadyparalyzed", "pixelmon.effect.isparalyzed");
    }

    @Override
    public boolean canAttackThisTurn(PixelmonWrapper user, Attack a) {
        if (RandomHelper.getRandomChance(25)) {
            user.bc.sendToAll("pixelmon.status.isparalyzed", user.getNickname());
            return false;
        }
        return true;
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (!(user.getBattleAbility() instanceof QuickFeet)) {
            int n = StatsType.Speed.getStatIndex();
            stats[n] = (int)((double)stats[n] * 0.5);
        }
        return stats;
    }

    @Override
    public StatusPersist restoreFromNBT(NBTTagCompound nbt) {
        return new Paralysis();
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(EnumType.Electric);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.paralysiscure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.paralysiscureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (userChoice.hitsAlly()) {
            return;
        }
        float weight = this.getWeightWithChance(25.0f);
        if (userChoice.isMiddleTier()) {
            for (PixelmonWrapper target : userChoice.targets) {
                AbilityBase ability = target.getBattleAbility();
                if (ability instanceof Guts || ability instanceof MarvelScale || ability instanceof QuickFeet || ability instanceof Synchronize) {
                    return;
                }
                if (!MoveChoice.hasPriority(bestOpponentChoices) && MoveChoice.canOutspeed(bestOpponentChoices, pw, bestUserChoices)) {
                    userChoice.raiseWeight(weight * 3.0f);
                }
                userChoice.raiseWeight(weight);
            }
        }
    }
}

