/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.EnumInitializeCategory;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.PowerConstruct;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumZygarde;
import com.pixelmonmod.pixelmon.items.ItemZygardeCube;
import com.pixelmonmod.pixelmon.listener.ZygardeCellsListener;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;

public class TileEntityZygardeAssembly
extends TileEntity
implements ITickable {
    private int ticks = 0;
    private Mode mode = Mode.INACTIVE;
    private UUID uuid = null;
    private StoragePosition position = null;
    private int cubeSlot = -999;

    public void activate(EntityPlayer player, IBlockState state, ItemStack hand) {
        if (ZygardeCellsListener.checkForCube(player)) {
            OpenScreen.open(player, EnumGuiScreen.ZygardeAssembly, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        } else {
            ChatHandler.sendChat((Entity)player, "pixelmon.blocks.reassembly_unit.nocube", new Object[0]);
        }
    }

    public void onSelection(EntityPlayerMP player, Mode mode, StoragePosition position, int cubeSlot) {
        ItemStack stack = player.field_71071_by.func_70301_a(cubeSlot);
        if (!(stack.func_77973_b() instanceof ItemZygardeCube)) {
            return;
        }
        this.uuid = player.func_110124_au();
        this.setMode(mode);
        this.position = position;
        this.cubeSlot = cubeSlot;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.INACTIVE) {
            this.ticks = 0;
        }
        this.func_70296_d();
        ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
    }

    public Mode getMode() {
        return this.mode;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.mode != Mode.INACTIVE) {
            ++this.ticks;
            if (this.ticks > 30) {
                EntityPlayer player = this.func_145831_w().func_152378_a(this.uuid);
                if (player == null) {
                    this.reset();
                    return;
                }
                ItemStack cube = player.field_71071_by.func_70301_a(this.cubeSlot);
                if (!(cube.func_77973_b() instanceof ItemZygardeCube)) {
                    this.reset();
                    return;
                }
                if (this.mode == Mode.SEPARATING && this.position != null) {
                    PlayerPartyStorage storage = Pixelmon.storageManager.getParty(this.uuid);
                    Pokemon pokemon = storage.get(this.position);
                    if (pokemon != null && pokemon.getSpecies() == EnumSpecies.Zygarde && !(pokemon.getAbility() instanceof PowerConstruct)) {
                        int cells;
                        int n = pokemon.getFormEnum() == EnumZygarde.TEN_PERCENT ? 10 : (cells = pokemon.getFormEnum() == EnumZygarde.FIFTY_PERCENT ? 50 : -1);
                        if (cells != -1) {
                            storage.retrieveAll();
                            storage.set(this.position, null);
                            ItemZygardeCube.setCellCount(cube, ItemZygardeCube.getCellCount(cube) + cells);
                            ItemZygardeCube.setCoreCount(cube, ItemZygardeCube.getCoreCount(cube) + 1);
                        }
                    }
                } else if (this.mode == Mode.ASSEMBLING && this.position != null) {
                    PlayerPartyStorage storage = Pixelmon.storageManager.getParty(this.uuid);
                    Pokemon pokemon = storage.get(this.position);
                    if (pokemon != null && pokemon.getSpecies() == EnumSpecies.Zygarde && !(pokemon.getAbility() instanceof PowerConstruct)) {
                        int count = ItemZygardeCube.getCellCount(cube);
                        int cores = ItemZygardeCube.getCoreCount(cube);
                        if (pokemon.getFormEnum() == EnumZygarde.TEN_PERCENT) {
                            if (count >= 90 && cores >= 1) {
                                pokemon.setForm(EnumZygarde.FIFTY_PERCENT);
                                pokemon.setAbility("PowerConstruct");
                                ItemZygardeCube.setCellCount(cube, ItemZygardeCube.getCellCount(cube) - 90);
                                ItemZygardeCube.setCoreCount(cube, ItemZygardeCube.getCoreCount(cube) - 1);
                            } else if (count >= 40) {
                                pokemon.setForm(EnumZygarde.FIFTY_PERCENT);
                                pokemon.setAbility("AuraBreak");
                                ItemZygardeCube.setCellCount(cube, ItemZygardeCube.getCellCount(cube) - 40);
                            }
                        } else if (pokemon.getFormEnum() == EnumZygarde.FIFTY_PERCENT && count >= 50 && cores >= 1) {
                            pokemon.setForm(EnumZygarde.FIFTY_PERCENT);
                            pokemon.setAbility("PowerConstruct");
                            ItemZygardeCube.setCellCount(cube, ItemZygardeCube.getCellCount(cube) - 50);
                            ItemZygardeCube.setCoreCount(cube, ItemZygardeCube.getCoreCount(cube) - 1);
                        }
                    }
                } else if (this.mode == Mode.ASSEMBLING) {
                    int cellsToRemove;
                    int count = ItemZygardeCube.getCellCount(cube);
                    int cores = ItemZygardeCube.getCoreCount(cube);
                    Pokemon zygarde = Pixelmon.pokemonFactory.create(EnumSpecies.Zygarde);
                    zygarde.initialize(new EnumInitializeCategory[0]);
                    if (count >= 100 && cores >= 2) {
                        zygarde.setForm(EnumZygarde.FIFTY_PERCENT);
                        zygarde.setAbility("PowerConstruct");
                        cellsToRemove = 100;
                    } else if (count >= 50 && cores >= 1) {
                        zygarde.setForm(EnumZygarde.FIFTY_PERCENT);
                        zygarde.setAbility("AuraBreak");
                        cellsToRemove = 50;
                    } else if (count >= 10 && cores >= 1) {
                        zygarde.setForm(EnumZygarde.TEN_PERCENT);
                        zygarde.setAbility("AuraBreak");
                        cellsToRemove = 10;
                    } else {
                        this.reset();
                        return;
                    }
                    zygarde.setLevel(30);
                    Pixelmon.storageManager.getParty(this.uuid).add(zygarde);
                    ItemZygardeCube.setCellCount(cube, ItemZygardeCube.getCellCount(cube) - cellsToRemove);
                    ItemZygardeCube.setCoreCount(cube, ItemZygardeCube.getCoreCount(cube) - (zygarde.getAbility() instanceof PowerConstruct ? 2 : 1));
                }
                this.reset();
            }
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74774_a("Mode", (byte)this.mode.ordinal());
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.func_145839_a(compound);
        this.mode = Mode.fromOrdinal(compound.func_74771_c("Mode"));
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    private void reset() {
        this.mode = Mode.INACTIVE;
        this.ticks = 0;
        this.uuid = null;
        this.position = null;
        this.cubeSlot = -999;
        this.func_70296_d();
        ((WorldServer)this.field_145850_b).func_184164_w().func_180244_a(this.field_174879_c);
    }

    public static enum Mode {
        INACTIVE,
        ASSEMBLING,
        SEPARATING;

        private static final Mode[] VALUES;

        public static Mode fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        static {
            VALUES = Mode.values();
        }
    }
}

