/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.elements;

import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import java.util.List;
import net.minecraft.util.NonNullList;
import org.lwjgl.input.Mouse;

public class GuiDropDownManager {
    private final List<GuiDropDown> dropDowns = NonNullList.func_191196_a();
    private boolean lastMouse;

    public void drawDropDowns(float partialTicks, int mouseX, int mouseY) {
        GuiDropDown active = null;
        int tempMouseX = mouseX;
        int tempMouseY = mouseY;
        for (GuiDropDown dropDown : this.dropDowns) {
            if (dropDown == null || !dropDown.active) continue;
            active = dropDown;
            if (!active.isMouseOver(mouseX, mouseY)) break;
            mouseY = -1;
            mouseX = -1;
            break;
        }
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            GuiDropDown dropDown;
            dropDown = this.dropDowns.get(i);
            if (dropDown == null || dropDown.active || !dropDown.getVisible()) continue;
            dropDown.drawScreen(mouseX, mouseY, partialTicks);
        }
        if (active != null) {
            active.drawScreen(tempMouseX, tempMouseY, partialTicks);
        }
        this.lastMouse = Mouse.isButtonDown((int)0);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean selected = false;
        for (int i = 0; i < this.dropDowns.size(); ++i) {
            GuiDropDown dropDown = this.dropDowns.get(i);
            if (dropDown == null) continue;
            if (dropDown.isMouseOver(mouseX, mouseY)) {
                selected = true;
            } else {
                dropDown.active = false;
            }
            selected = selected || dropDown.getLastSelected();
        }
        return selected;
    }

    public void addDropDown(GuiDropDown dropDown) {
        dropDown.setManager(this);
        this.dropDowns.add(dropDown);
    }

    public void removeDropDown(GuiDropDown dropDown) {
        this.dropDowns.remove(dropDown);
    }

    public void clearDropDowns() {
        this.dropDowns.clear();
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.dropDowns == null || this.dropDowns.isEmpty()) {
            return false;
        }
        return this.dropDowns.stream().anyMatch(dropDown -> dropDown != null && dropDown.isMouseOver(mouseX, mouseY));
    }

    boolean getLastMouse() {
        return this.lastMouse;
    }
}

