/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.factory.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.config.Node;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ReflectionNodeElement
implements IConfigElement {
    private final Field field;
    Object defaultValue;
    String name;
    String humanName;
    String comment;
    Number lowerBound = Integer.MIN_VALUE;
    Number upperBound = Integer.MAX_VALUE;
    boolean useSlider = false;
    boolean requiresRestart = false;
    Consumer<Object> reloadFunction = o -> {};

    public ReflectionNodeElement(Field field, Object defaultValue) {
        this.field = field;
        this.defaultValue = defaultValue;
        this.field.setAccessible(true);
        this.readAnnotation(field);
    }

    public void readAnnotation(Field field) {
        String name;
        Node node = field.getAnnotation(Node.class);
        this.name = name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
        this.humanName = I18n.func_74838_a((String)("pixelmon.config." + name));
        this.comment = I18n.func_74838_a((String)("pixelmon.config." + name + ".comment"));
        this.useSlider = node.useSlider();
        this.requiresRestart = node.requiresRestart();
        if (this.getType() == ConfigGuiType.INTEGER) {
            this.lowerBound = (int)node.minValue();
            this.upperBound = (int)node.maxValue();
        } else {
            this.lowerBound = node.minValue();
            this.upperBound = node.maxValue();
        }
    }

    public void setReloadFunction(Consumer<Object> reloadFunction) {
        this.reloadFunction = reloadFunction;
    }

    public boolean isProperty() {
        return true;
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        if (this.useSlider) {
            return GuiConfigEntries.NumberSliderEntry.class;
        }
        return null;
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return null;
    }

    public String getName() {
        return this.humanName;
    }

    public String getQualifiedName() {
        return null;
    }

    public String getLanguageKey() {
        return "";
    }

    public String getComment() {
        if (this.comment != null && !this.comment.isEmpty()) {
            return this.comment;
        }
        return "No comment?";
    }

    public List<IConfigElement> getChildElements() {
        return null;
    }

    public ConfigGuiType getType() {
        return this.getType(this.defaultValue);
    }

    public ConfigGuiType getType(Object value) {
        if (value instanceof Boolean) {
            return ConfigGuiType.BOOLEAN;
        }
        if (value instanceof Integer) {
            return ConfigGuiType.INTEGER;
        }
        if (value instanceof String) {
            return ConfigGuiType.STRING;
        }
        if (value instanceof Double || value instanceof Float) {
            return ConfigGuiType.DOUBLE;
        }
        if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                return this.getType(list.get(0));
            }
            return ConfigGuiType.STRING;
        }
        Pixelmon.LOGGER.error("TODO getType " + value.getClass());
        return ConfigGuiType.STRING;
    }

    public boolean isList() {
        return this.defaultValue instanceof List;
    }

    public boolean isListLengthFixed() {
        return false;
    }

    public int getMaxListLength() {
        return -1;
    }

    public boolean isDefault() {
        return true;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public Object[] getDefaults() {
        if (this.defaultValue instanceof List) {
            return ((List)this.defaultValue).toArray();
        }
        return null;
    }

    public void setToDefault() {
        this.set(this.getDefault());
    }

    public boolean requiresWorldRestart() {
        return false;
    }

    public boolean showInGui() {
        return true;
    }

    public boolean requiresMcRestart() {
        return this.requiresRestart;
    }

    public Object get() {
        try {
            if (this.field.getType().isEnum()) {
                return ((Enum)this.field.get(null)).ordinal();
            }
            return this.field.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return this.defaultValue;
        }
    }

    public Object[] getList() {
        List list = (List)this.get();
        return list.toArray();
    }

    public void set(Object value) {
        try {
            if (this.field.getType().isEnum()) {
                this.field.set(null, this.field.getType().getEnumConstants()[(Integer)value]);
            } else if (this.field.getType() == Float.TYPE && value instanceof Double) {
                this.field.setFloat(null, ((Double)value).floatValue());
            } else {
                this.field.set(null, value);
            }
            this.reloadFunction.accept(value);
            PixelmonConfig.saveConfig();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void set(Object[] aVal) {
        try {
            if (aVal.length >= 1) {
                Object type = aVal[0];
                if (type instanceof String) {
                    this.set(Lists.newArrayList((Object[])Arrays.copyOf(aVal, aVal.length, String[].class)));
                } else if (type instanceof Integer) {
                    this.set(Lists.newArrayList((Object[])Arrays.copyOf(aVal, aVal.length, Integer[].class)));
                }
            } else {
                this.set(null);
            }
            this.reloadFunction.accept(aVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PixelmonConfig.saveConfig();
    }

    public String[] getValidValues() {
        return new String[0];
    }

    public String[] getValidValuesDisplay() {
        return new String[0];
    }

    public Object getMinValue() {
        return this.lowerBound;
    }

    public Object getMaxValue() {
        return this.upperBound;
    }

    public Pattern getValidationPattern() {
        return null;
    }
}

