/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.inventory;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiButtonPokeChecker;
import com.pixelmonmod.pixelmon.client.gui.inventory.IInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.gui.inventory.SlotInventoryPixelmon;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetHeldItem;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetOvalCharm;
import com.pixelmonmod.pixelmon.comm.packetHandlers.SetShinyCharm;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.ChangeLurePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ServerSwap;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.ItemLure;
import com.pixelmonmod.pixelmon.listener.EntityPlayerExtension;
import com.pixelmonmod.pixelmon.storage.ClientData;
import java.awt.Color;
import java.text.NumberFormat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

class InventoryPixelmon<T extends InventoryEffectRenderer> {
    private T gui;
    private int partyWidth;
    private SlotInventoryPixelmon[] pixelmonSlots;
    private StoragePosition selected;
    private GuiButtonPokeChecker pokeChecker;
    private boolean drawerOut = false;
    private int drawerOffset = 0;
    private int[] lureSlot;
    private int ticksTillClick = 0;

    InventoryPixelmon(T gui, int partyWidth) {
        this.gui = gui;
        this.pixelmonSlots = new SlotInventoryPixelmon[6];
        this.partyWidth = partyWidth;
    }

    void initGui() {
        int slotLeft = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 34;
        int slotTop = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + 21;
        this.lureSlot = new int[]{slotLeft - 16 - (this.gui instanceof GuiContainerCreative ? 1 : 0), slotTop + 20};
        this.pokeChecker = new GuiButtonPokeChecker((GuiScreen)this.gui);
        ((IInventoryPixelmon)this.gui).getButtonList().add(this.pokeChecker);
        this.reloadSlots();
    }

    private void reloadSlots() {
        int i;
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            this.pixelmonSlots[i] = null;
        }
        for (i = 0; i < this.pixelmonSlots.length; ++i) {
            StoragePosition position = new StoragePosition(-1, i);
            Pokemon pokemon = ClientStorageManager.party.get(i);
            if (pokemon == null) continue;
            int x = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 8;
            int y = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 75;
            this.pixelmonSlots[i] = new SlotInventoryPixelmon(x, y, position);
        }
    }

    void drawScreen(int mouseX, int mouseY, float partialTicks) {
        boolean recipeBookVisible;
        boolean bl = recipeBookVisible = this.gui instanceof GuiInventory && ((GuiInventory)this.gui).func_194310_f().func_191878_b();
        if (((InventoryEffectRenderer)this.gui).field_147045_u && !recipeBookVisible) {
            ((InventoryEffectRenderer)this.gui).field_147045_u = false;
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
            ((InventoryEffectRenderer)this.gui).field_147045_u = true;
        } else {
            ((IInventoryPixelmon)this.gui).superDrawScreen(mouseX, mouseY, partialTicks);
        }
        if (recipeBookVisible) {
            return;
        }
        GlStateManager.func_179140_f();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            if ((!this.pokeChecker.field_146124_l || mouseY < this.pokeChecker.field_146129_i || mouseY > this.pokeChecker.field_146129_i + this.pokeChecker.field_146121_g) && slot.getBounds().contains(mouseX, mouseY)) {
                this.drawPokemonInfo(pokemon, mouseX, mouseY);
                continue;
            }
            if (pokemon.isEgg() || !slot.getHeldItemBounds().contains(mouseX, mouseY) || !this.heldItemQualifies(pokemon) || this.ticksTillClick > 0) continue;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonCreativeInventory);
            if (pokemon.getHeldItem().func_190926_b()) continue;
            ((IInventoryPixelmon)this.gui).renderToolTipPublic(pokemon.getHeldItem(), mouseX, mouseY);
        }
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        if (ClientStorageManager.party.getLure() != null) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_180450_b(ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1]);
            ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_180453_a(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p, ClientStorageManager.party.getLureStack(), this.lureSlot[0], this.lureSlot[1], null);
            if (mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
                ((IInventoryPixelmon)this.gui).renderToolTipPublic(ClientStorageManager.party.getLureStack(), mouseX, mouseY);
            }
        }
        if (Pixelmon.devEnvironment) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_175063_a("oX: " + (mouseX - (((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth)) + " oY: " + (mouseY - ((InventoryEffectRenderer)this.gui).field_146295_m / 2), (float)(mouseX + 10), (float)(mouseY + 10), Color.red.getRGB());
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawerOut && this.drawerOffset < 42) {
            this.drawerOffset += 3;
            if (this.drawerOffset > 42) {
                this.drawerOffset = 42;
            }
        } else if (!this.drawerOut && this.drawerOffset > 0) {
            this.drawerOffset -= 3;
            if (this.drawerOffset < 0) {
                this.drawerOffset = 0;
            }
        }
    }

    void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71460_t.func_78478_c();
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(true);
        for (SlotInventoryPixelmon slot : this.pixelmonSlots) {
            Pokemon pokemon;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (slot == null || (pokemon = ClientStorageManager.party.get(slot.position)) == null) continue;
            slot.setX(((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 8);
            GuiHelper.bindPokemonSprite(pokemon, ((InventoryEffectRenderer)this.gui).field_146297_k);
            GlStateManager.func_179140_f();
            GuiHelper.drawImageQuad(slot.x, slot.y, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
            if (!pokemon.isEgg()) {
                if (pokemon.getHeldItem() != ItemStack.field_190927_a) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.func_175599_af().func_175042_a(pokemon.getHeldItem(), slot.heldItemX, slot.heldItemY);
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.heldItem);
                    GuiHelper.drawImageQuad(slot.heldItemX + 3, slot.heldItemY + 3, 10.0, 10.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                }
            }
            if (!slot.position.equals(this.selected)) continue;
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pcResources);
            GuiHelper.drawImageQuad((float)slot.x + 0.5f, (float)slot.y + 0.5f, 15.0, 15.0f, 0.0, 0.11328125, 0.11328125, 0.2265625, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        if ((ClientStorageManager.party.getLure() != null || ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_77973_b() instanceof ItemLure) && mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16) {
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlayExtended2);
            GuiHelper.drawImageQuad(this.lureSlot[0] - 1, this.lureSlot[1] - 1, 18.0, 18.0f, 0.23046875, 0.7265625, 0.30078125, 0.796875, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlayExtended2);
        int bX = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((InventoryEffectRenderer)this.gui).field_146295_m / 2;
        if (this.drawerOffset > 0) {
            GuiHelper.drawImageQuad(bX - 7 - this.drawerOffset, bY - 83, 7 + this.drawerOffset, 166.0f, 0.609375, 0.0, (163.0f + (float)this.drawerOffset) / 256.0f, 0.6484375, ((IInventoryPixelmon)this.gui).getZLevel());
            if (this.drawerOut && mouseX >= bX - 49 && mouseX <= bX - 43 && mouseY >= bY - 10 && mouseY <= bY + 9) {
                GuiHelper.drawImageQuad(bX - 46, bY - 3, 3.0, 6.0f, 0.01171875, 0.6875, 0.0234375, 0.7109375, ((IInventoryPixelmon)this.gui).getZLevel());
            }
            if (this.drawerOffset > 30) {
                EnumMegaItemsUnlocked megaItems;
                EnumFeatureState ovalCharm;
                EnumFeatureState shinyCharm = EntityPlayerExtension.getPlayerShinyCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g);
                if (shinyCharm.isAvailable()) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.shinyCharmBig);
                    GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY + 42, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (!shinyCharm.isActive()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.disabled);
                        GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY + 42, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    }
                }
                if ((ovalCharm = EntityPlayerExtension.getPlayerOvalCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g)).isAvailable()) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.ovalCharmBig);
                    GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY + 6, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (!ovalCharm.isActive()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.disabled);
                        GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY + 6, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    }
                }
                if ((megaItems = EntityPlayerExtension.getPlayerMegaItemsUnlocked((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g)).canMega()) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.keyStoneBig);
                    GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY - 30, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (!EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g).canEvolve()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.disabled);
                        GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY - 30, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    }
                }
                if (megaItems.canDynamax()) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.dynamaxBandBig);
                    GuiHelper.drawImageQuad(bX + 10 - this.drawerOffset, bY - 67, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (!EntityPlayerExtension.getPlayerMegaItem((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g).canDynamax()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.disabled);
                        GuiHelper.drawImageQuad(bX + 11 - this.drawerOffset, bY - 67, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, ((IInventoryPixelmon)this.gui).getZLevel());
                    }
                }
            }
        } else if (mouseX >= bX - 7 && mouseX <= bX - 1 && mouseY >= bY - 10 && mouseY <= bY + 9) {
            GuiHelper.drawImageQuad(bX - 4, bY - 3, 3.0, 6.0f, 0.0, 0.6875, 0.01171875, 0.7109375, ((IInventoryPixelmon)this.gui).getZLevel());
        }
        GuiHelper.drawStringRightAligned(NumberFormat.getInstance().format(ClientData.playerMoney), ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 42, (float)((InventoryEffectRenderer)this.gui).field_146295_m / 2.0f + 66.0f, 0xFFFFFF, true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78264_a(false);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    private boolean heldItemQualifies(Pokemon pokemon) {
        ItemStack handStack = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        ItemStack heldStack = pokemon.getHeldItem();
        if (handStack.func_190926_b() && !heldStack.func_190926_b()) {
            return true;
        }
        return !handStack.func_190926_b() && handStack.func_77973_b() instanceof ItemHeld;
    }

    private void drawPokemonInfo(Pokemon pokemon, int x, int y) {
        if (pokemon != null) {
            x = Math.max(x - 84, 0);
            GuiScreen.func_73734_a((int)x, (int)(y - 2), (int)(x + 80), (int)(y + 20), (int)-1437248170);
            String displayName = pokemon.getDisplayName();
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(displayName, x + 2, y, 0xFFFFFF);
            ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.pixelmonOverlay);
            if (!pokemon.isEgg()) {
                if (pokemon.getGender() == Gender.Male) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.male);
                    GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                } else if (pokemon.getGender() == Gender.Female) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71446_o.func_110577_a(GuiResources.female);
                    GuiHelper.drawImageQuad(((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(displayName) + x + 3, y, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
                }
                String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getLevel();
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(levelString, x + 3, y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                if (pokemon.getHealth() <= 0) {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]), x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth(), x + 7 + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.func_78256_a(levelString), y + ((InventoryEffectRenderer)this.gui).field_146297_k.field_71466_p.field_78288_b + 1, 0xFFFFFF);
                }
            }
        }
    }

    boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseX >= this.lureSlot[0] && mouseX <= this.lureSlot[0] + 16 && mouseY >= this.lureSlot[1] && mouseY <= this.lureSlot[1] + 16 && this.ticksTillClick <= 0) {
            ItemStack held = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            ItemStack lure = ClientStorageManager.party.getLureStack();
            boolean creative = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71075_bZ.field_75098_d;
            if (held.func_190926_b() && lure.func_190926_b()) {
                return false;
            }
            if (held.func_77973_b() instanceof ItemLure) {
                if (lure.func_190926_b()) {
                    ClientStorageManager.party.setLureStack(lure);
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                    Pixelmon.network.sendToServer((IMessage)(creative ? new ChangeLurePacket(ChangeLurePacket.Change.PUT, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.PUT)));
                } else {
                    ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(lure);
                    ClientStorageManager.party.setLureStack(held);
                    Pixelmon.network.sendToServer((IMessage)(creative ? new ChangeLurePacket(ChangeLurePacket.Change.SWAP, held.func_77973_b(), held.func_77952_i()) : new ChangeLurePacket(ChangeLurePacket.Change.SWAP)));
                }
            } else if (!lure.func_190926_b() && held.func_190926_b()) {
                ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by.func_70437_b(lure);
                ClientStorageManager.party.setLureStack(ItemStack.field_190927_a);
                Pixelmon.network.sendToServer((IMessage)new ChangeLurePacket(ChangeLurePacket.Change.TAKE));
            }
            this.ticksTillClick = 10;
            return false;
        }
        if (this.pokeChecker.func_146115_a()) {
            if (mouseButton == 0) {
                this.pokeChecker.mouseClicked(mouseX, mouseY);
            }
            return false;
        }
        for (int i = 0; i < this.pixelmonSlots.length; ++i) {
            int slotY;
            int slotX;
            Pokemon pokemon;
            SlotInventoryPixelmon slot = this.pixelmonSlots[i];
            StoragePosition position = slot == null ? null : slot.position;
            Pokemon pokemon2 = pokemon = position == null ? null : ClientStorageManager.party.get(position);
            if (slot != null) {
                slotX = slot.x;
                slotY = slot.y;
            } else {
                slotX = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth + 6;
                slotY = ((InventoryEffectRenderer)this.gui).field_146295_m / 2 + i * 18 - 75;
            }
            if (mouseX >= slotX && mouseX <= slotX + 16 && mouseY >= slotY && mouseY <= slotY + 16) {
                if (mouseButton == 1) {
                    this.pokeChecker.setPokemon(ClientStorageManager.party, position, pokemon, mouseX, mouseY);
                } else {
                    this.pokeChecker.setPokemon(null, null, null, mouseX, mouseY);
                }
                if (mouseButton == 0) {
                    if (this.selected == null) {
                        this.selected = position;
                    } else {
                        Pixelmon.network.sendToServer((IMessage)new ServerSwap(this.selected, ClientStorageManager.party.get(this.selected), new StoragePosition(-1, i), pokemon));
                        ClientStorageManager.party.swap(this.selected.order, i);
                        this.selected = null;
                        this.reloadSlots();
                    }
                }
                return false;
            }
            if (this.ticksTillClick > 0 || pokemon == null || pokemon.isEgg() || !this.heldItemQualifies(pokemon) || !slot.getHeldItemBounds().contains(mouseX, mouseY)) continue;
            SetHeldItem packet = new SetHeldItem(position, pokemon.getUUID());
            InventoryPlayer inventory = ((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71071_by;
            ItemStack currentItem = inventory.func_70445_o();
            ItemStack oldItem = pokemon.getHeldItem();
            if (((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g.field_71075_bZ.field_75098_d) {
                if (!currentItem.func_190926_b()) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    packet.setItem(currentItem.func_77973_b());
                } else {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    packet.setItem(null);
                }
            } else {
                ItemStack playerItem;
                if (oldItem.func_190926_b()) {
                    if (!currentItem.func_190926_b()) {
                        ItemStack singleItem = currentItem.func_77946_l();
                        singleItem.func_190920_e(1);
                        pokemon.setHeldItem(singleItem);
                        if (currentItem.func_190916_E() <= 1) {
                            inventory.func_70437_b(ItemStack.field_190927_a);
                        } else {
                            currentItem.func_190918_g(1);
                        }
                    }
                } else if (currentItem.func_190926_b()) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    inventory.func_70437_b(oldItem);
                } else if (ItemStack.func_179545_c((ItemStack)oldItem, (ItemStack)currentItem) && ItemStack.func_77970_a((ItemStack)oldItem, (ItemStack)currentItem)) {
                    pokemon.setHeldItem(ItemStack.field_190927_a);
                    currentItem.func_190917_f(1);
                } else if (currentItem.func_190916_E() <= 1) {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    inventory.func_70437_b(oldItem);
                } else {
                    ItemStack singleItem = currentItem.func_77946_l();
                    singleItem.func_190920_e(1);
                    pokemon.setHeldItem(singleItem);
                    currentItem.func_190918_g(1);
                    inventory.func_70441_a(oldItem);
                }
                if (!(playerItem = inventory.func_70445_o()).func_190926_b() && playerItem.func_190916_E() > 64) {
                    playerItem.func_190920_e(64);
                }
            }
            Pixelmon.network.sendToServer((IMessage)packet);
            this.ticksTillClick = 10;
            return false;
        }
        int bX = ((IInventoryPixelmon)this.gui).getGUILeft() - this.partyWidth;
        int bY = ((InventoryEffectRenderer)this.gui).field_146295_m / 2;
        if (this.drawerOut) {
            if (mouseX >= bX - 49 && mouseX <= bX - 43 && mouseY >= bY - 10 && mouseY <= bY + 9) {
                this.drawerOut = false;
                return false;
            }
            if (mouseX >= bX - 31 && mouseX <= bX - 7) {
                EnumFeatureState charm;
                if (mouseY >= bY + 36 + 6 && mouseY <= bY + 60 + 6) {
                    charm = EntityPlayerExtension.getPlayerShinyCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g);
                    if (charm.isAvailable()) {
                        Pixelmon.network.sendToServer((IMessage)new SetShinyCharm(charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY >= bY + 6 && mouseY <= bY + 24 + 6) {
                    charm = EntityPlayerExtension.getPlayerOvalCharm((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g);
                    if (charm.isAvailable()) {
                        Pixelmon.network.sendToServer((IMessage)new SetOvalCharm(charm.isActive() ? EnumFeatureState.Available : EnumFeatureState.Active));
                    }
                    return false;
                }
                if (mouseY >= bY - 36 + 6 && mouseY <= bY - 12 + 6) {
                    if (EntityPlayerExtension.getPlayerMegaItemsUnlocked((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g).canMega()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.func_147108_a((GuiScreen)new GuiMegaItem(false));
                    }
                    return false;
                }
                if (mouseY >= bY - 73 + 6 && mouseY <= bY - 49 + 6) {
                    if (EntityPlayerExtension.getPlayerMegaItemsUnlocked((EntityPlayer)((InventoryEffectRenderer)this.gui).field_146297_k.field_71439_g).canDynamax()) {
                        ((InventoryEffectRenderer)this.gui).field_146297_k.func_147108_a((GuiScreen)new GuiMegaItem(true));
                    }
                    return false;
                }
            }
        } else if (mouseX >= bX - 7 && mouseX <= bX - 1 && mouseY >= bY - 10 && mouseY <= bY + 9) {
            this.drawerOut = true;
            return false;
        }
        return true;
    }

    public void tick() {
        if (this.ticksTillClick > 0) {
            --this.ticksTillClick;
        }
    }
}

