/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityFossilCleaner;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.BlockModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.items.ItemCoveredFossil;
import com.pixelmonmod.pixelmon.items.ItemFossil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public class RenderTileFossilCleaner
extends TileEntityRenderer<TileEntityFossilCleaner> {
    private static final ResourceLocation texture = new ResourceLocation("pixelmon", "textures/blocks/fossilCleaner.png");
    private static final BlockModelHolder<GenericSmdModel> fossilCleaner = new BlockModelHolder("blocks/fossil_cleaner/fossil_cleaner.pqc");
    private static final BlockModelHolder<GenericSmdModel> fossilCleanerArm = new BlockModelHolder("blocks/fossil_cleaner/fossil_cleaner_arm.pqc");
    private static final GenericSmdModel fossilCleanerGlass = new GenericSmdModel("models/blocks/fossil_cleaner", "fossil_cleaner_glass.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredHelixFossil = new BlockModelHolder("fossils/covered/covered_helix.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredDomeFossil = new BlockModelHolder("fossils/covered/covered_dome.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredOldAmber = new BlockModelHolder("fossils/covered/covered_oldamber.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredClawFossil = new BlockModelHolder("fossils/covered/covered_claw.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredSkullFossil = new BlockModelHolder("fossils/covered/covered_skull.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredArmorFossil = new BlockModelHolder("fossils/covered/covered_armor.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredCoverFossil = new BlockModelHolder("fossils/covered/covered_cover.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredPlumeFossil = new BlockModelHolder("fossils/covered/covered_plume.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredJawFossil = new BlockModelHolder("fossils/covered/covered_jaw.pqc");
    private static final BlockModelHolder<GenericSmdModel> coveredSailFossil = new BlockModelHolder("fossils/covered/covered_sail.pqc");

    public RenderTileFossilCleaner() {
        this.correctionAngles = 180;
        RenderTileFossilCleaner.fossilCleanerGlass.modelRenderer.setTransparent(0.5f);
    }

    @Override
    public void renderTileEntity(TileEntityFossilCleaner cleaner, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        if (cleaner.renderPass == 1) {
            this.func_147499_a(texture);
            fossilCleanerGlass.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
            return;
        }
        int frame = cleaner.timer >= 360 ? 0 : cleaner.timer * 2;
        this.func_147499_a(texture);
        ((GenericSmdModel)((Object)fossilCleaner.getModel())).setFrame(frame);
        fossilCleaner.render();
        ((GenericSmdModel)((Object)fossilCleanerArm.getModel())).setFrame(frame);
        fossilCleanerArm.render();
        Item itemInside = cleaner.getItemInCleaner();
        if (itemInside != null) {
            BlockModelHolder<GenericSmdModel> fossilModel = null;
            if (itemInside instanceof ItemCoveredFossil) {
                ItemCoveredFossil coveredFossil = (ItemCoveredFossil)itemInside;
                switch (coveredFossil.cleanedFossil.getFossil()) {
                    case HELIX: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png"));
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case DOME: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_dome_fossilmodel.png"));
                        fossilModel = coveredDomeFossil;
                        break;
                    }
                    case OLD_AMBER: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_old_amber_fossilmodel.png"));
                        fossilModel = coveredOldAmber;
                        break;
                    }
                    case ROOT: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_helix_fossilmodel.png"));
                        fossilModel = coveredHelixFossil;
                        break;
                    }
                    case CLAW: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_claw_fossilmodel.png"));
                        fossilModel = coveredClawFossil;
                        break;
                    }
                    case SKULL: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_skull_fossilmodel.png"));
                        fossilModel = coveredSkullFossil;
                        break;
                    }
                    case ARMOR: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_armor_fossilmodel.png"));
                        fossilModel = coveredArmorFossil;
                        break;
                    }
                    case COVER: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_cover_fossilmodel.png"));
                        fossilModel = coveredCoverFossil;
                        break;
                    }
                    case PLUME: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_plume_fossilmodel.png"));
                        fossilModel = coveredPlumeFossil;
                        break;
                    }
                    case JAW: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_jaw_fossilmodel.png"));
                        fossilModel = coveredJawFossil;
                        break;
                    }
                    case SAIL: {
                        this.func_147499_a(new ResourceLocation("pixelmon", "textures/fossils/covered/covered_sail_fossilmodel.png"));
                        fossilModel = coveredSailFossil;
                        break;
                    }
                    default: {
                        Pixelmon.LOGGER.warn("Unknown covered Fossil present. Name: " + ((Object)((Object)coveredFossil)).toString());
                        break;
                    }
                }
            } else if (itemInside instanceof ItemFossil) {
                ItemFossil fossil = (ItemFossil)itemInside;
                this.func_147499_a(fossil.getFossil().getTexture());
                fossilModel = (BlockModelHolder<GenericSmdModel>)fossil.getFossil().getModel();
            } else {
                Pixelmon.LOGGER.warn("Unrecognised item type in Fossil cleaner: " + itemInside.func_77658_a());
            }
            if (fossilModel != null) {
                if (itemInside instanceof ItemCoveredFossil) {
                    ((GenericSmdModel)((Object)fossilModel.getModel())).setFrame(frame);
                    fossilModel.render();
                } else {
                    GlStateManager.func_179137_b((double)0.0, (double)-0.555, (double)0.0);
                    fossilModel.render();
                }
            }
        }
    }
}

