/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.battles.BattleMessageEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleMessage;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ChatHandler {
    public static void sendChat(Entity entityLiving, String string, Object ... data) {
        ChatHandler.sendChat((ICommandSender)entityLiving, ChatHandler.getMessage(string, data));
    }

    public static void sendChat(ICommandSender receiver, TextComponentTranslation message) {
        if (receiver != null && receiver instanceof EntityPlayerMP) {
            receiver.func_145747_a((ITextComponent)message);
        }
    }

    public static void sendChat(ICommandSender owner, ICommandSender owner2, String string, Object ... data) {
        TextComponentTranslation textComponentTranslation = ChatHandler.getMessage(string, data);
        ChatHandler.sendChat(owner, textComponentTranslation);
        ChatHandler.sendChat(owner2, textComponentTranslation);
    }

    public static void sendFormattedChat(ICommandSender receiver, TextFormatting chatFormat, String string, Object ... data) {
        TextComponentTranslation textComponentTranslation = new TextComponentTranslation(string, data);
        textComponentTranslation.func_150256_b().func_150238_a(chatFormat);
        ChatHandler.sendChat(receiver, textComponentTranslation);
    }

    public static void sendBattleMessage(Entity user, String string, Object ... data) {
        TextComponentTranslation textComponentTranslation = new TextComponentTranslation(string, data);
        textComponentTranslation.func_150256_b().func_150238_a(TextFormatting.GRAY);
        ChatHandler.sendBattleMessage(user, textComponentTranslation);
    }

    public static void sendBattleMessage(Entity user, TextComponentTranslation chat) {
        if (chat.func_150268_i() != null && !chat.func_150268_i().isEmpty()) {
            if (user != null && user instanceof EntityPlayerMP) {
                Pixelmon.network.sendTo((IMessage)new BattleMessage(chat), (EntityPlayerMP)user);
            }
            Pixelmon.EVENT_BUS.post((Event)new BattleMessageEvent(user, chat));
        }
    }

    public static void sendBattleMessage(ArrayList<BattleParticipant> participants, String string, Object ... data) {
        ChatHandler.sendBattleMessage(participants, ChatHandler.getMessage(string, data));
    }

    public static void sendBattleMessage(ArrayList<BattleParticipant> participants, TextComponentTranslation message) {
        for (BattleParticipant p : participants) {
            ChatHandler.sendBattleMessage((Entity)p.getEntity(), message);
        }
        ArrayList<Spectator> spectators = participants.get((int)0).bc.spectators;
        spectators.forEach(spectator -> spectator.sendBattleMessage(message));
    }

    public static TextComponentTranslation getMessage(String string, Object ... data) {
        TextComponentTranslation message = new TextComponentTranslation(string, data);
        message.func_150256_b().func_150238_a(TextFormatting.GRAY);
        return message;
    }

    public static void sendMessageToAllPlayers(MinecraftServer minecraftServer, String string) {
        TextComponentTranslation translation = new TextComponentTranslation(string, new Object[0]);
        minecraftServer.func_184103_al().func_148539_a((ITextComponent)translation);
    }
}

