/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockReveal;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class IlluminatePositionsPacket
implements IMessage {
    public int dimension;
    public int durationTicks;
    public HashMap<BlockPos, Tuple<Integer, Integer>> locationColors = new HashMap();

    public IlluminatePositionsPacket() {
    }

    public IlluminatePositionsPacket(int dimension, int durationTicks, HashMap<BlockPos, Tuple<Integer, Integer>> locationColors) {
        this.dimension = dimension;
        this.durationTicks = durationTicks;
        this.locationColors = locationColors;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readByte();
        this.durationTicks = buf.readUnsignedShort();
        int locationCount = buf.readUnsignedShort();
        for (int i = 0; i < locationCount; ++i) {
            BlockPos pos = new BlockPos(buf.readInt(), (int)buf.readShort(), buf.readInt());
            int color = buf.readInt();
            int pattern = buf.readInt();
            this.locationColors.put(pos, (Tuple<Integer, Integer>)new Tuple((Object)color, (Object)pattern));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.dimension);
        buf.writeShort(this.durationTicks);
        buf.writeShort(this.locationColors.size());
        for (Map.Entry<BlockPos, Tuple<Integer, Integer>> entry : this.locationColors.entrySet()) {
            buf.writeInt(entry.getKey().func_177958_n());
            buf.writeShort(entry.getKey().func_177956_o());
            buf.writeInt(entry.getKey().func_177952_p());
            buf.writeInt(((Integer)entry.getValue().func_76341_a()).intValue());
            buf.writeInt(((Integer)entry.getValue().func_76340_b()).intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<IlluminatePositionsPacket, IMessage> {
        public IMessage onMessage(IlluminatePositionsPacket message, MessageContext ctx) {
            for (Map.Entry<BlockPos, Tuple<Integer, Integer>> entry : message.locationColors.entrySet()) {
                BlockRevealRenderer.revealedBlocks.add(new BlockReveal(message.dimension, message.durationTicks, entry.getKey(), (Integer)entry.getValue().func_76341_a(), (Integer)entry.getValue().func_76340_b()));
            }
            return null;
        }
    }
}

