/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.pokemon.SpecFlag;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerConfigList
implements IMessage {
    int computerBoxCount;
    public boolean allowCapturingOutsideBattle;
    public int maxLevel;
    public float ridingSpeedMultiplier;
    public boolean afkHandlerOn;
    public int afkTimerActivateSeconds;
    public boolean renderWildLevels;
    public boolean allowShinyCharmFromPokedex;
    public boolean allowExternalMoves;
    public boolean limitShopKeeperStackSize;
    public ArrayList<SpecFlag> flags = new ArrayList();

    public ServerConfigList() {
        this.computerBoxCount = PixelmonConfig.computerBoxes;
        this.allowCapturingOutsideBattle = PixelmonConfig.allowCapturingOutsideBattle;
        this.renderWildLevels = PixelmonConfig.renderWildLevels;
        this.maxLevel = PixelmonConfig.maxLevel;
        this.ridingSpeedMultiplier = PixelmonConfig.ridingSpeedMultiplier;
        this.afkHandlerOn = PixelmonConfig.afkHandlerOn;
        this.afkTimerActivateSeconds = PixelmonConfig.afkTimerActivateSeconds;
        this.allowShinyCharmFromPokedex = PixelmonConfig.allowShinyCharmFromPokedex;
        this.allowExternalMoves = PixelmonConfig.allowExternalMoves;
        this.limitShopKeeperStackSize = PixelmonConfig.limitShopKeeperStackSize;
        if (PokemonSpec.extraSpecTypes != null) {
            for (ISpecType specType : PokemonSpec.extraSpecTypes) {
                if (!(specType instanceof SpecFlag)) continue;
                SpecFlag flag = (SpecFlag)specType;
                this.flags.add(flag);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.computerBoxCount = buf.readInt();
        this.allowCapturingOutsideBattle = buf.readBoolean();
        this.renderWildLevels = buf.readBoolean();
        this.maxLevel = buf.readInt();
        this.ridingSpeedMultiplier = buf.readFloat();
        this.afkHandlerOn = buf.readBoolean();
        this.afkTimerActivateSeconds = buf.readInt();
        this.allowShinyCharmFromPokedex = buf.readBoolean();
        this.allowExternalMoves = buf.readBoolean();
        this.limitShopKeeperStackSize = buf.readBoolean();
        int n = buf.readUnsignedByte();
        for (int i = 0; i < n; ++i) {
            int m = buf.readUnsignedByte();
            ArrayList<String> aliases = new ArrayList<String>();
            for (int j = 0; j < m; ++j) {
                aliases.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
            }
            this.flags.add(new SpecFlag(aliases.toArray(new String[m])));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.computerBoxCount);
        buf.writeBoolean(this.allowCapturingOutsideBattle);
        buf.writeBoolean(this.renderWildLevels);
        buf.writeInt(this.maxLevel);
        buf.writeFloat(this.ridingSpeedMultiplier);
        buf.writeBoolean(this.afkHandlerOn);
        buf.writeInt(this.afkTimerActivateSeconds);
        buf.writeBoolean(this.allowShinyCharmFromPokedex);
        buf.writeBoolean(this.allowExternalMoves);
        buf.writeBoolean(this.limitShopKeeperStackSize);
        buf.writeByte(this.flags.size());
        for (SpecFlag flag : this.flags) {
            buf.writeByte(flag.aliases.size());
            for (String alias : flag.aliases) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)alias);
            }
        }
    }

    public static class Handler
    implements ISyncHandler<ServerConfigList> {
        @Override
        public void onSyncMessage(ServerConfigList message, MessageContext ctx) {
            PixelmonServerConfig.updateFromServer(message);
            ClientStorageManager.load();
            GuiPixelmonOverlay.hideSpectateMessage(null);
            for (SpecFlag flag : message.flags) {
                if (PokemonSpec.getSpecForKey(flag.key) != null) continue;
                PokemonSpec.extraSpecTypes.add(flag);
            }
        }
    }
}

