/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.pc.ClientQueryResultsPC;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.StringUtils;

public class ServerQueryPC
implements IMessage {
    private int searchId;
    private String query;

    public ServerQueryPC() {
    }

    public ServerQueryPC(int searchId, String query) {
        this.searchId = searchId;
        this.query = query;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.searchId);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.query);
    }

    public void fromBytes(ByteBuf buf) {
        this.searchId = buf.readShort();
        this.query = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public static List<Pokemon> search(PokemonStorage storage, String query) {
        List<Pokemon> list;
        String name;
        if (query.contains(" ")) {
            name = query.substring(0, query.indexOf(" "));
            PokemonSpec spec = new PokemonSpec(query.substring(query.indexOf(" ") + 1));
            if (spec.name != null) {
                return new ArrayList<Pokemon>();
            }
            spec.egg = false;
            list = storage.findAll(spec);
        } else if (query.equals("eggs")) {
            name = "all";
            list = storage.findAll(Pokemon::isEgg);
        } else {
            name = query;
            list = new ArrayList<Pokemon>(Arrays.asList(storage.getAll()));
            list.removeIf(Objects::isNull);
        }
        if (!name.equals("all")) {
            list.removeIf(poke -> !poke.getDisplayName().toLowerCase().contains(name) && !poke.getSpecies().name.toLowerCase().contains(name) && (poke.isEgg() || !poke.getSpecies().name.contains(name)));
        }
        return list;
    }

    public static class Handler
    implements ISyncHandler<ServerQueryPC> {
        @Override
        public void onSyncMessage(ServerQueryPC message, MessageContext ctx) {
            String query = message.query.replaceAll(" +", " ").toLowerCase();
            if (!StringUtils.isBlank((CharSequence)query)) {
                PCStorage pc = Pixelmon.storageManager.getPCForPlayer(ctx.getServerHandler().field_147369_b);
                List<Pokemon> results = ServerQueryPC.search(pc, query);
                Pixelmon.network.sendTo((IMessage)new ClientQueryResultsPC(message.searchId, results), ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

