/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.items.ItemNPCEditor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class StoreTutorData
implements IMessage {
    ArrayList<Attack> attackList;
    ArrayList<ArrayList<ItemStack>> costs;
    int tutorID;

    public StoreTutorData() {
    }

    public StoreTutorData(int tutorID) {
        this.attackList = GuiTutor.attackList;
        this.costs = GuiTutor.costs;
        this.tutorID = tutorID;
    }

    public void fromBytes(ByteBuf buf) {
        this.attackList = new ArrayList();
        this.costs = new ArrayList();
        NPCTutor.decode(buf, this.attackList, this.costs);
        this.tutorID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NPCTutor.encode(buf, this.attackList, this.costs);
        buf.writeInt(this.tutorID);
    }

    public static class Handler
    implements IMessageHandler<StoreTutorData, IMessage> {
        public IMessage onMessage(StoreTutorData message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (!ItemNPCEditor.checkPermission((EntityPlayer)player)) {
                return null;
            }
            Optional<NPCTutor> entityNPCOptional = EntityNPC.locateNPCServer(player.field_70170_p, message.tutorID, NPCTutor.class);
            if (entityNPCOptional.isPresent()) {
                NPCTutor tutor = entityNPCOptional.get();
                tutor.attackList = message.attackList;
                tutor.costs = message.costs;
            }
            return null;
        }
    }
}

