/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnSet;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex.SendSpawnData;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RequestSpawnData
implements IMessage {
    public int npn;

    public RequestSpawnData() {
    }

    public RequestSpawnData(int npn) {
        this.npn = npn;
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.npn);
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.npn = byteBuf.readInt();
    }

    public static class Handler
    implements ISyncHandler<RequestSpawnData> {
        @Override
        public void onSyncMessage(RequestSpawnData message, MessageContext ctx) {
            EnumPokedexRegisterStatus status = Pixelmon.storageManager.getParty((EntityPlayerMP)ctx.getServerHandler().field_147369_b).pokedex.get(message.npn);
            ArrayList spawnData = Lists.newArrayList();
            if (status != EnumPokedexRegisterStatus.unknown) {
                ArrayList<SpawnSet> spawns;
                EnumSpecies species = EnumSpecies.getFromDex(message.npn);
                ArrayList<SpawnSet> arrayList = spawns = Arrays.stream(EnumSpecies.LEGENDARY_ENUMS).anyMatch(e -> e == species) ? PixelmonSpawning.legendaries : PixelmonSpawning.standard;
                if (species != null) {
                    for (SpawnSet spawn : spawns) {
                        if (!spawn.id.equalsIgnoreCase(species.name)) continue;
                        for (SpawnInfo info : spawn.spawnInfos) {
                            if (info == null || info.condition == null || info.condition.biomes == null) continue;
                            for (Biome biome : info.condition.biomes) {
                                Pokedex.PokedexSpawnData data = new Pokedex.PokedexSpawnData(biome);
                                if (info.condition.times != null) {
                                    for (WorldTime time : info.condition.times) {
                                        data.addTime(time);
                                    }
                                }
                                if (info.condition.weathers != null) {
                                    for (WeatherType weather : info.condition.weathers) {
                                        data.addWeather(weather);
                                    }
                                }
                                if (info.condition.maxY != null) {
                                    data.setMaxY(info.condition.maxY);
                                }
                                if (info.condition.minY != null) {
                                    data.setMinY(info.condition.minY);
                                }
                                spawnData.add(data);
                            }
                        }
                    }
                }
            }
            Pixelmon.network.sendTo((IMessage)new SendSpawnData(message.npn, spawnData), ctx.getServerHandler().field_147369_b);
        }
    }
}

