/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.RegexPatterns;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class Battle2
extends PixelmonCommand {
    @Override
    public String func_71517_b() {
        return "pokebattle2";
    }

    @Override
    public String func_71518_a(ICommandSender icommandsender) {
        return "/pokebattle2 <player> <player|pokemon> <player|pokemon> <player|pokemon>";
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            this.sendMessage(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        try {
            BattleParticipant[] team2;
            BattleParticipant[] team1;
            ArrayList<BattleParticipant> participants = new ArrayList<BattleParticipant>();
            ArrayList<EntityPixelmon> wildPixelmon = new ArrayList<EntityPixelmon>();
            ArrayList<String> playerNames = new ArrayList<String>();
            int numParticipants = 0;
            for (String arg : args) {
                if (arg.startsWith("lvl")) continue;
                ++numParticipants;
            }
            if (numParticipants < 2 || numParticipants > 4) {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("lvl")) continue;
                Object part = this.getPart(Battle2.getServer(), sender, args[i]);
                if (part == null) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.invalid", i + 1);
                    return;
                }
                if (part instanceof EntityPlayerMP) {
                    EntityPlayerMP playerPart = (EntityPlayerMP)part;
                    if (BattleRegistry.getBattle((EntityPlayer)playerPart) != null) {
                        this.sendMessage(sender, TextFormatting.RED, "sendpixelmon.inbattle", playerPart.func_145748_c_());
                        return;
                    }
                    if (playerNames.contains(playerPart.getDisplayNameString())) {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.duplicate", new Object[0]);
                        return;
                    }
                    playerNames.add(playerPart.getDisplayNameString());
                    PlayerPartyStorage party = Pixelmon.storageManager.getParty(playerPart);
                    List<Pokemon> availablePokemon = party.findAll(pokemon -> !pokemon.isEgg() && pokemon.getHealth() > 0);
                    EntityPixelmon[] leadPokemon = numParticipants == 2 || numParticipants == 3 && i == 0 ? (availablePokemon.isEmpty() ? new EntityPixelmon[]{null, null} : (availablePokemon.size() == 1 ? new EntityPixelmon[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart)} : new EntityPixelmon[]{availablePokemon.get(0).getOrSpawnPixelmon((Entity)playerPart), availablePokemon.get(1).getOrSpawnPixelmon((Entity)playerPart)})) : new EntityPixelmon[]{party.getAndSendOutFirstAblePokemon((Entity)playerPart)};
                    if (leadPokemon.length > 0 && leadPokemon[0] != null) {
                        participants.add(new PlayerParticipant(playerPart, leadPokemon));
                        continue;
                    }
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle.nopokemon", playerPart.func_145748_c_());
                    return;
                }
                if (part instanceof EntityPixelmon) {
                    EntityPixelmon wildPart = (EntityPixelmon)part;
                    if (i == 0) {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.first", new Object[0]);
                        return;
                    }
                    if (i + 1 < args.length && args[i + 1].startsWith("lvl")) {
                        int level = Integer.parseInt(RegexPatterns.LETTERS.matcher(args[i + 1]).replaceAll(""));
                        if (level > 0 && level <= PixelmonServerConfig.maxLevel) {
                            wildPart.getLvl().setLevel(level);
                        } else {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.cheater", new Object[0]);
                        }
                    } else {
                        wildPart.getLvl().setLevel(((PlayerParticipant)participants.get(0)).getHighestLevel());
                    }
                    wildPixelmon.add(wildPart);
                    participants.add(new WildPixelmonParticipant(wildPart));
                    continue;
                }
                if (!(part instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)part);
                if (trainer.battleController != null) {
                    this.sendMessage(sender, TextFormatting.RED, "sendpixelmon.inbattle", trainer.func_70005_c_());
                    return;
                }
                participants.add(new TrainerParticipant(trainer, 2));
            }
            EntityPlayerMP player = ((PlayerParticipant)participants.get((int)0)).player;
            for (int i = 0; i < wildPixelmon.size(); ++i) {
                EntityPixelmon p = (EntityPixelmon)wildPixelmon.get(i);
                p.aggression = EnumAggression.passive;
                if (i == 0) {
                    p.func_70107_b(player.field_70165_t + 2.0, Battle2.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v), player.field_70161_v);
                } else if (i == 1) {
                    p.func_70107_b(player.field_70165_t, Battle2.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v), player.field_70161_v + 2.0);
                } else if (i == 2) {
                    p.func_70107_b(player.field_70165_t + 2.0, Battle2.getTopEarthBlock(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70161_v), player.field_70161_v + 2.0);
                }
                player.field_70170_p.func_72838_d((Entity)p);
            }
            ArrayList battleParticipants = new ArrayList();
            if (numParticipants == 2) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1)};
            } else if (numParticipants == 3) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(1), (BattleParticipant)participants.get(2)};
                for (BattleParticipant participant : team2) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else if (numParticipants == 4) {
                team1 = new BattleParticipant[]{(BattleParticipant)participants.get(0), (BattleParticipant)participants.get(1)};
                team2 = new BattleParticipant[]{(BattleParticipant)participants.get(2), (BattleParticipant)participants.get(3)};
                for (BattleParticipant participant : participants) {
                    if (!(participant instanceof TrainerParticipant)) continue;
                    participant.setNumControlledPokemon(1);
                }
            } else {
                CommandChatHandler.sendChat(sender, "pixelmon.command.battle2.cantstart", new Object[0]);
                return;
            }
            ((PlayerParticipant)participants.get((int)0)).startedBattle = true;
            BattleRegistry.startBattle(team1, team2, new BattleRules(EnumBattleType.Double));
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.level", new Object[0]);
        }
        catch (ClassCastException e) {
            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.battle2.cantstart", new Object[0]);
        }
        catch (Exception e) {
            System.out.println("Error loading player for command /pokebattle2 " + args[0] + "  " + args[1]);
            e.printStackTrace();
        }
    }

    public static int getTopEarthBlock(World world, int cpX, int cpZ) {
        Chunk chunk = world.func_175726_f(new BlockPos(cpX, 0, cpZ));
        Integer k = null;
        k = Math.max(0, Math.min(chunk.func_76625_h() + 15, 255));
        while (k > 0) {
            Block block = world.func_180495_p(new BlockPos(cpX, k.intValue(), cpZ)).func_177230_c();
            if (block != Blocks.field_150350_a && !block.isFoliage((IBlockAccess)world, new BlockPos(cpX, k.intValue(), cpZ))) {
                return k + 1;
            }
            k = k - 1;
        }
        return chunk.func_76625_h() + 15;
    }

    private Object getPart(MinecraftServer server, ICommandSender sender, String value) {
        EntityPlayerMP player = Battle2.getPlayer(sender, value);
        if (player != null) {
            return player;
        }
        PokemonSpec spec = new PokemonSpec(value.split(","));
        if (spec.name == null) {
            String langCode = sender instanceof EntityPlayerMP ? ((EntityPlayerMP)sender).field_71148_cg : "en_US";
            Optional<NPCTrainer> trainer = EntityNPC.locateNPCServer(sender.func_130014_f_(), value, NPCTrainer.class, langCode);
            if (trainer.isPresent()) {
                return trainer.get();
            }
            return null;
        }
        return spec.create(sender.func_130014_f_());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length >= 1 && args.length <= 4) {
            return Battle2.tabCompleteUsernames(args);
        }
        return Collections.emptyList();
    }
}

