/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.commands.Battle2;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleType;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class BattleCommand
extends PixelmonCommand {
    public BattleCommand() {
        super("pokebattle", "/pokebattle <participant1> <participant2> [<participant3> <participant4>]", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2 || args.length == 4) {
            EntityPlayer source;
            int i;
            BattleRules br = new BattleRules();
            br.battleType = args.length == 2 ? EnumBattleType.Single : EnumBattleType.Double;
            Object[] entities = new Entity[args.length];
            for (i = 0; i < entities.length; ++i) {
                entities[i] = BattleCommand.require(this.getParticipant(sender, args[i]), "pixelmon.command.battle2.invalid", i + 1);
            }
            if (CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer) != null) {
                NPCTrainer trainer = (NPCTrainer)CollectionHelper.find(Lists.newArrayList((Object[])entities), e -> e instanceof NPCTrainer);
                if (!trainer.battleRules.isDefault()) {
                    br.importText(trainer.battleRules.exportText());
                }
            }
            for (i = 0; i < entities.length; ++i) {
                Object e2 = entities[i];
                for (int j = 0; j < entities.length; ++j) {
                    if (i == j || ((Entity)e2).field_70170_p == ((Entity)entities[j]).field_70170_p) continue;
                    BattleCommand.endCommand("pixelmon.command.battle.dimension", new Object[0]);
                }
                int requiredPokemon = 1;
                if (e2 instanceof EntityPlayerMP) {
                    PlayerPartyStorage party;
                    EntityPlayerMP player = (EntityPlayerMP)e2;
                    for (int j = 0; j < entities.length; ++j) {
                        if (i == j || e2 != entities[j]) continue;
                        if (br.battleType == EnumBattleType.Single) {
                            BattleCommand.endCommand("pixelmon.command.battle2.duplicate", new Object[0]);
                            continue;
                        }
                        if (br.battleType != EnumBattleType.Double) continue;
                        ++requiredPokemon;
                        if ((i >= 2 || j < 2) && (j >= 2 || i < 2)) continue;
                        BattleCommand.endCommand("pixelmon.command.battle2.differing", new Object[0]);
                    }
                    if (BattleRegistry.getBattle((EntityPlayer)e2) != null) {
                        BattleCommand.endCommand("pixelmon.command.battle.cannotchallenge", player.func_70005_c_());
                    }
                    BattleCommand.require((party = Pixelmon.storageManager.getParty(player)).countAblePokemon() >= requiredPokemon, requiredPokemon > 1 ? "pixelmon.command.battle.notenoughpokemon" : "pixelmon.command.battle.nopokemon", player.getDisplayNameString());
                    continue;
                }
                if (!(e2 instanceof NPCTrainer)) continue;
                NPCTrainer trainer = (NPCTrainer)((Object)e2);
                if (trainer.battleController == null) continue;
                BattleCommand.endCommand("pixelmon.command.battle.cannotchallenge", trainer.func_70005_c_());
            }
            Object object = source = sender instanceof EntityPlayer ? (EntityPlayer)sender : Arrays.stream(entities).filter(entity -> entity instanceof EntityPlayerMP || entity instanceof EntityNPC).findFirst().get();
            if (br.battleType == EnumBattleType.Single) {
                BattleParticipant one = this.prepareParticipant((Entity)entities[0], br.battleType.numPokemon, (Entity)source);
                BattleParticipant two = this.prepareParticipant((Entity)entities[1], br.battleType.numPokemon, (Entity)source);
                BattleRegistry.startBattle(new BattleParticipant[]{one}, new BattleParticipant[]{two}, br);
                BattleCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.battle.started", (Object[])new Object[]{one.getDisplayName(), two.getDisplayName()});
            } else if (br.battleType == EnumBattleType.Double) {
                BattleParticipant[] battleParticipantArray;
                BattleParticipant[] battleParticipantArray2;
                BattleParticipant[][] teams = new BattleParticipant[2][];
                Object one = entities[0];
                Object two = entities[1];
                Object three = entities[2];
                Object four = entities[3];
                if (one == two) {
                    BattleParticipant[] battleParticipantArray3 = new BattleParticipant[1];
                    battleParticipantArray2 = battleParticipantArray3;
                    battleParticipantArray3[0] = this.prepareParticipant((Entity)one, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray4 = new BattleParticipant[2];
                    battleParticipantArray4[0] = this.prepareParticipant((Entity)one, 1, (Entity)source);
                    battleParticipantArray2 = battleParticipantArray4;
                    battleParticipantArray4[1] = this.prepareParticipant((Entity)two, 1, (Entity)source);
                }
                teams[0] = battleParticipantArray2;
                if (three == four) {
                    BattleParticipant[] battleParticipantArray5 = new BattleParticipant[1];
                    battleParticipantArray = battleParticipantArray5;
                    battleParticipantArray5[0] = this.prepareParticipant((Entity)three, 2, (Entity)source);
                } else {
                    BattleParticipant[] battleParticipantArray6 = new BattleParticipant[2];
                    battleParticipantArray6[0] = this.prepareParticipant((Entity)three, 1, (Entity)source);
                    battleParticipantArray = battleParticipantArray6;
                    battleParticipantArray6[1] = this.prepareParticipant((Entity)four, 1, (Entity)source);
                }
                teams[1] = battleParticipantArray;
                BattleRegistry.startBattle(teams[0], teams[1], br);
                BattleCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.battle.started", (Object[])new Object[]{Arrays.toString(Arrays.stream(teams[0]).map(BattleParticipant::getDisplayName).toArray()), Arrays.toString(Arrays.stream(teams[1]).map(BattleParticipant::getDisplayName).toArray())});
            }
        } else {
            sender.func_145747_a(BattleCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            BattleCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    private BattleParticipant prepareParticipant(Entity e, int numPokemon, Entity source) {
        if (e instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)e;
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            List<Pokemon> pokemon = party.findAll(pk -> pk.getHealth() > 0 && !pk.isEgg());
            EntityPixelmon[] pixelmons = new EntityPixelmon[numPokemon];
            for (int i = 0; i < pixelmons.length; ++i) {
                pixelmons[i] = pokemon.get(i).getOrSpawnPixelmon((Entity)player);
            }
            return new PlayerParticipant(player, pixelmons);
        }
        if (e instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)e;
            return new TrainerParticipant(trainer, numPokemon);
        }
        if (e instanceof EntityPixelmon) {
            EntityPixelmon pixelmon = (EntityPixelmon)e;
            pixelmon.aggression = EnumAggression.passive;
            pixelmon.func_70107_b(source.field_70165_t + 2.0, Battle2.getTopEarthBlock(source.field_70170_p, (int)source.field_70165_t, (int)source.field_70161_v), source.field_70161_v);
            pixelmon.field_70170_p.func_72838_d((Entity)pixelmon);
            return new WildPixelmonParticipant(pixelmon);
        }
        return null;
    }

    private Entity getParticipant(ICommandSender sender, String value) {
        EntityPlayerMP playerMP = BattleCommand.getEntityPlayer(value);
        if (playerMP != null) {
            return playerMP;
        }
        playerMP = BattleCommand.getPlayer(sender, value);
        if (playerMP != null) {
            return playerMP;
        }
        PokemonSpec spec = new PokemonSpec(value.split(","));
        if (spec.name != null) {
            BlockPos pos = sender.func_180425_c();
            EntityPixelmon pixelmon = spec.create(sender.func_130014_f_());
            pixelmon.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            return pixelmon;
        }
        String langCode = sender instanceof EntityPlayerMP ? ((EntityPlayerMP)sender).field_71148_cg : "en_US";
        Optional<NPCTrainer> trainer = EntityNPC.locateNPCServer(sender.func_130014_f_(), value, NPCTrainer.class, langCode);
        return trainer.orElse(null);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length <= 4) {
            List<String> list = BattleCommand.tabCompleteUsernames(args);
            if (list.isEmpty()) {
                list = BattleCommand.tabCompletePokemon(args);
            }
            return list;
        }
        return Collections.emptyList();
    }
}

