/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.events.SpectateEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EndSpectate;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartSpectate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpectateCommand
extends PixelmonCommand {
    @Override
    public String func_71517_b() {
        return "spectate";
    }

    @Override
    public String func_71518_a(ICommandSender arg0) {
        return "/spectate <playerName>";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = SpectateCommand.requireEntityPlayer(sender);
        if (args.length == 0) {
            if (!BattleRegistry.removeSpectator(player)) {
                this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
            }
            Pixelmon.network.sendTo((IMessage)new EndSpectate(), player);
        } else if (args.length == 1) {
            EntityPlayerMP target = SpectateCommand.requireEntityPlayer(args[0]);
            if (target == player) {
                SpectateCommand.endCommand("pixelmon.command.spectate.self", new Object[0]);
            }
            if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                SpectateCommand.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            BattleControllerBase base = SpectateCommand.require(BattleRegistry.getBattle((EntityPlayer)target), "pixelmon.command.spectate.nobattle", target.getDisplayNameString());
            PlayerParticipant watchedPlayer = SpectateCommand.require(base.getPlayer(target.func_70005_c_()), "commands.generic.exception", new Object[0]);
            if (!Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StartSpectate(player, base, target))) {
                Pixelmon.network.sendTo((IMessage)new StartBattle(base.battleIndex, base.getBattleType(watchedPlayer), base.rules), player);
                Pixelmon.network.sendTo((IMessage)new SetAllBattlingPokemon(PixelmonInGui.convertToGUI(Arrays.asList(watchedPlayer.allPokemon))), player);
                ArrayList<PixelmonWrapper> teamList = watchedPlayer.getTeamPokemonList();
                Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(teamList), player);
                Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(PixelmonInGui.convertToGUI(teamList), false), player);
                Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(watchedPlayer.getOpponentData(), true), player);
                if (base.getTeam(watchedPlayer).size() > 1) {
                    Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(watchedPlayer.getAllyData()), player);
                }
                Pixelmon.network.sendTo((IMessage)new StartSpectate(watchedPlayer.player.func_110124_au(), base.rules.battleType), player);
                base.addSpectator(new Spectator(player, target.func_70005_c_()));
            }
        } else {
            sender.func_145747_a(SpectateCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            SpectateCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? SpectateCommand.tabCompleteUsernames(args) : SpectateCommand.tabComplete(args, new String[0]);
    }
}

