/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.worldGeneration.structure.gyms.GymInfo;
import com.pixelmonmod.pixelmon.worldGeneration.structure.towns.ComponentTownPart;
import com.pixelmonmod.pixelmon.worldGeneration.structure.util.StructureScattered;
import com.pixelmonmod.pixelmon.worldGeneration.structure.worldGen.WorldGenGym;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class StrucCommand
extends PixelmonCommand {
    public StrucCommand() {
        super("struc", "/struc [name]", 4);
    }

    @Override
    public String func_71517_b() {
        return "struc";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        StructureInfo structure;
        World world = sender.func_130014_f_();
        BlockPos cc = sender.func_180425_c();
        Random random = RandomHelper.staticRandomWithXZSeed(world, cc.func_177958_n() >> 4, cc.func_177952_p() >> 4);
        if (args.length == 0) {
            structure = StructureRegistry.getScatteredStructureFromBiome(random, world.func_180494_b(cc));
            if (structure == null) {
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.command.struc.nostruc", new Object[]{world.func_180494_b(cc).getRegistryName().func_110623_a()}));
                return;
            }
        } else {
            if (args[0].equals("list")) {
                StringBuilder stringBuilder = new StringBuilder();
                for (String name : StructureRegistry.structureIds) {
                    stringBuilder.append(name).append(" ");
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(stringBuilder.toString()));
                return;
            }
            structure = StructureRegistry.getByID(args[0]);
        }
        if (structure == null) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.command.struc.notfound", new Object[]{args[0]}));
            return;
        }
        StructureScattered ss = structure.createStructure(random, cc, true, false, StrucCommand.func_71521_c((ICommandSender)sender).func_174811_aO(), args.length > 1 && args[1].startsWith("technical"));
        if (!ss.generate(world, random)) {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("pixelmon.command.struc.cantfit", new Object[]{cc.toString()}));
        } else if (structure instanceof GymInfo) {
            GymInfo gymInfo = (GymInfo)structure;
            int level = -1;
            if (args.length > 1 && args[1].startsWith("lvl")) {
                try {
                    int parseLevel = Integer.parseInt(args[1].replaceFirst("lvl", ""));
                    if (parseLevel > 0) {
                        level = Math.min(parseLevel, PixelmonServerConfig.maxLevel);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            gymInfo.level = level;
            WorldGenGym.spawnNPCs(world, ss, gymInfo);
        } else {
            ComponentTownPart.spawnVillagers(ss, structure, world, ss.func_74874_b());
        }
    }

    @Override
    public String func_71518_a(ICommandSender icommandsender) {
        return "/struc [name]";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return StrucCommand.tabComplete(args, StructureRegistry.structureIds);
    }
}

