/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.econ;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.economy.IPixelmonBankAccount;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class BankTransferCommand
extends PixelmonCommand {
    public BankTransferCommand() {
        super("transfer", "/transfer <player> <money>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 2) {
            EntityPlayerMP target;
            EntityPlayerMP player = BankTransferCommand.requireEntityPlayer(sender);
            if (player == (target = BankTransferCommand.requireEntityPlayer(args[0]))) {
                BankTransferCommand.endCommand("pixelmon.command.transfer.sameplayer", new Object[0]);
            }
            int amount = BankTransferCommand.requireInt(args[1], 1, 999999, "commands.generic.num.invalid", new Object[0]);
            IPixelmonBankAccount userAccount = Pixelmon.moneyManager.getBankAccount(player).orElseThrow(() -> new NullPointerException("bank account"));
            IPixelmonBankAccount targetAccount = Pixelmon.moneyManager.getBankAccount(target).orElseThrow(() -> new NullPointerException("bank account"));
            if (userAccount.getMoney() < amount) {
                BankTransferCommand.endCommand("pixelmon.command.transfer.notenoughmoney", new Object[0]);
            }
            int beforeCurrency = targetAccount.getMoney();
            int currencyDifference = targetAccount.changeMoney(amount) - beforeCurrency;
            if (currencyDifference == 0) {
                if (amount > 0) {
                    this.sendMessage(sender, "pixelmon.command.givemoney.moneylimit", target.func_145748_c_());
                } else {
                    this.sendMessage(sender, "pixelmon.command.givemoney.nomoney", target.func_145748_c_());
                }
                targetAccount.setMoney(beforeCurrency);
            } else {
                userAccount.changeMoney(-currencyDifference);
                String currencyString = Integer.toString(currencyDifference);
                BankTransferCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.transfer.notifytransfer", (Object[])new Object[]{sender.func_70005_c_(), currencyString, target.func_145748_c_()});
                this.sendMessage(sender, "pixelmon.command.transfer.transferred", currencyString, target.func_145748_c_());
                this.sendMessage((ICommandSender)target, "pixelmon.command.transfer.received", player.func_145748_c_(), currencyString);
            }
        } else {
            sender.func_145747_a(BankTransferCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            BankTransferCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length != 1 ? BankTransferCommand.tabComplete(args, new String[0]) : BankTransferCommand.tabCompleteUsernames(args);
    }
}

