/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumClobbopus;
import com.pixelmonmod.pixelmon.enums.forms.EnumMagikarp;
import com.pixelmonmod.pixelmon.enums.forms.EnumShellos;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.tuple.Pair;

public class FormLogRegistry {
    private static Map<EnumSpecies, LinkedHashMultimap<Integer, PokemonSpec>> registry = Maps.newHashMap();
    public static Object[] combinedWeights = Stream.of(EnumClobbopus.OLD_ROD_WEIGHTS, EnumMagikarp.OLD_ROD_WEIGHTS, EnumShellos.OLD_ROD_WEIGHTS).flatMap(Stream::of).toArray();
    public static double totalWeight = 0.0;

    public static void init() {
        for (int i = 0; i < combinedWeights.length; ++i) {
            totalWeight += (double)((Integer)((Pair)combinedWeights[i]).getRight()).intValue();
        }
        registry.clear();
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 0, new PokemonSpec("form:0 !s"), new PokemonSpec("form:2 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 1, new PokemonSpec("form:3 !s"), new PokemonSpec("form:4 !s"), new PokemonSpec("form:5 !s"), new PokemonSpec("form:6 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 2, new PokemonSpec("form:7 !s"), new PokemonSpec("form:8 !s"), new PokemonSpec("form:9 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 3, new PokemonSpec("form:10 !s"), new PokemonSpec("form:11 !s"), new PokemonSpec("form:12 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 4, new PokemonSpec("form:13 !s"), new PokemonSpec("form:14 !s"), new PokemonSpec("form:15 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 5, new PokemonSpec("form:16 !s"), new PokemonSpec("form:17 !s"), new PokemonSpec("form:18 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 6, new PokemonSpec("form:19 !s"), new PokemonSpec("form:20 !s"), new PokemonSpec("form:21 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 7, new PokemonSpec("form:22 !s"), new PokemonSpec("form:23 !s"), new PokemonSpec("form:24 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 8, new PokemonSpec("form:25 !s"), new PokemonSpec("form:26 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 9, new PokemonSpec("form:27 !s"), new PokemonSpec("form:28 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 10, new PokemonSpec("form:29 !s"), new PokemonSpec("form:30 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 11, new PokemonSpec("form:31 !s"), new PokemonSpec("form:32 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Magikarp, 12, new PokemonSpec("shiny"), new PokemonSpec("form:1 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Shellos, 0, new PokemonSpec("form:0 !s"));
        FormLogRegistry.createCategory(EnumSpecies.Shellos, 1, new PokemonSpec("form:1 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:2 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:3 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:4 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:5 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:6 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:7 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:8 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:9 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:10 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:11 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:12 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:13 !s"));
        registry.get(EnumSpecies.Shellos).get((Object)0).add(new PokemonSpec("form:0 s"));
        registry.get(EnumSpecies.Shellos).get((Object)1).add(new PokemonSpec("form:1 s"));
        FormLogRegistry.createCategory(EnumSpecies.Clobbopus, 0, new PokemonSpec("form:0 !s"), new PokemonSpec("form:1 !s"), new PokemonSpec("form:2 !s"), new PokemonSpec("form:3 !s"), new PokemonSpec("form:4 !s"), new PokemonSpec("form:5 !s"), new PokemonSpec("form:6 !s"), new PokemonSpec("form:7 !s"), new PokemonSpec("form:8 !s"), new PokemonSpec("form:9 !s"), new PokemonSpec("shiny"));
    }

    public static Stream<EnumSpecies> getSpeciesList() {
        return registry.keySet().stream().sorted();
    }

    public static LinkedHashMultimap<Integer, PokemonSpec> getFormsForSpecies(EnumSpecies species) {
        if (registry.isEmpty()) {
            FormLogRegistry.init();
        }
        return registry.getOrDefault(species, (LinkedHashMultimap<Integer, PokemonSpec>)LinkedHashMultimap.create());
    }

    public static int getFormId(EnumSpecies species, PokemonSpec form) {
        LinkedHashMultimap<Integer, PokemonSpec> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return specs.indexOf(form);
    }

    public static int getFirstIdFromPokemon(Pokemon pokemon) {
        LinkedHashMultimap<Integer, PokemonSpec> map = FormLogRegistry.getFormsForSpecies(pokemon.getSpecies());
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        for (int i = 0; i < specs.size(); ++i) {
            if (!((PokemonSpec)specs.get(i)).matches(pokemon)) continue;
            return i;
        }
        return -1;
    }

    public static PokemonSpec getFormFromId(EnumSpecies species, int id) {
        LinkedHashMultimap<Integer, PokemonSpec> map = FormLogRegistry.getFormsForSpecies(species);
        ArrayList specs = Lists.newArrayList((Iterable)map.values());
        return (PokemonSpec)specs.get(id);
    }

    public static void createCategory(EnumSpecies species, int category, PokemonSpec ... forms) {
        if (!registry.containsKey(species)) {
            registry.put(species, (LinkedHashMultimap<Integer, PokemonSpec>)LinkedHashMultimap.create());
        }
        Multimap map = (Multimap)registry.get(species);
        map.putAll((Object)category, (Iterable)Lists.newArrayList((Object[])forms));
    }

    public static void createCategory(EnumSpecies species, int category, int entries) {
        if (!registry.containsKey(species)) {
            registry.put(species, (LinkedHashMultimap<Integer, PokemonSpec>)LinkedHashMultimap.create());
        }
        Multimap map = (Multimap)registry.get(species);
        int max = map.values().stream().mapToInt(spec -> spec.form + 1).max().orElse(0);
        ArrayList forms = Lists.newArrayList();
        for (int i = max; i < entries + max; ++i) {
            forms.add(new PokemonSpec("form:" + i));
        }
        map.putAll((Object)category, (Iterable)forms);
    }

    public static void createCategory(EnumSpecies species, int entries) {
        if (!registry.containsKey(species)) {
            FormLogRegistry.createCategory(species, 1, entries);
        } else {
            Multimap map = (Multimap)registry.get(species);
            int max = map.keySet().stream().mapToInt(spec -> spec).max().orElse(0);
            FormLogRegistry.createCategory(species, max + 1, entries);
        }
    }

    public static int[] getData(EntityPlayerMP target, EnumSpecies species) {
        Map<Short, Short> cells = Pixelmon.storageManager.getParty((EntityPlayerMP)target).pokedex.seenForms(species);
        int[] data = new int[FormLogRegistry.getFormsForSpecies(species).size()];
        cells.forEach((key, value) -> {
            data[key.shortValue()] = value.shortValue();
        });
        return data;
    }

    public static int[] getMenuData(EntityPlayerMP playerIn) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(registry.size());
        FormLogRegistry.getSpeciesList().forEachOrdered(species -> {
            list.add(species.getNationalPokedexInteger());
            int[] data = FormLogRegistry.getData(playerIn, species);
            list.add(data.length);
            for (int i : data) {
                list.add(i);
            }
        });
        int[] ret = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = (Integer)list.get(i);
        }
        return ret;
    }

    public static IEnumForm getRandomFish() {
        int randomIndex = -1;
        double random = Math.random() * totalWeight;
        for (int i = 0; i < combinedWeights.length; ++i) {
            if (!((random -= (double)((Integer)((Pair)combinedWeights[i]).getRight()).intValue()) <= 0.0)) continue;
            randomIndex = i;
            break;
        }
        return (IEnumForm)((Pair)combinedWeights[randomIndex]).getLeft();
    }
}

