/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.ConfigMigrationHandler;
import com.pixelmonmod.pixelmon.config.EnumForceBattleResult;
import com.pixelmonmod.pixelmon.config.EnumPokelootModes;
import com.pixelmonmod.pixelmon.config.EnumPokelootRate;
import com.pixelmonmod.pixelmon.config.Node;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleAIMode;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.UltraSpace;
import info.pixelmon.repack.ninja.leaping.configurate.ConfigurationOptions;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import info.pixelmon.repack.ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import info.pixelmon.repack.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class PixelmonConfig {
    @Node(category=Category.GENERAL, nameOverride="awardPhotos")
    public static boolean awardTokens = false;
    @Node(category=Category.GENERAL, nameOverride="allowPokemonNicknames")
    public static boolean allowNicknames = true;
    @Node(category=Category.GENERAL, nameOverride="allowAnvilAutoreloading")
    public static boolean allowAnvilAutoloading = false;
    @Node(category=Category.GENERAL, nameOverride="allowVanillaMobs", requiresRestart=true)
    public static boolean allowNonPixelmonMobs = false;
    @Node(category=Category.GENERAL, nameOverride="allowCaptureOutsideBattle", requiresRestart=true)
    public static boolean allowCapturingOutsideBattle = true;
    @Node(category=Category.GENERAL)
    public static boolean allowRandomPokemonToBeLegendary = true;
    @Node(category=Category.GENERAL, nameOverride="growthScaleModifier", minValue=0.0, maxValue=2.0, useSlider=true)
    public static double growthModifier = 1.0;
    @Node(category=Category.GENERAL)
    public static boolean pokemonDropsEnabled = true;
    @Node(category=Category.GENERAL)
    public static boolean printErrors = true;
    @Node(category=Category.GENERAL)
    public static boolean allowPlanting = true;
    @Node(category=Category.GENERAL, minValue=0.0)
    public static int maximumPlants = 32;
    @Node(category=Category.GENERAL, nameOverride="allowPvPExperience")
    public static boolean allowPVPExperience = true;
    @Node(category=Category.GENERAL)
    public static boolean allowTrainerExperience = true;
    @Node(category=Category.GENERAL)
    public static boolean returnHeldItems = true;
    @Node(category=Category.GENERAL, minValue=0.0, maxValue=2.0, useSlider=true)
    public static EnumForceBattleResult forceEndBattleResult = EnumForceBattleResult.WINNER;
    @Node(category=Category.GENERAL)
    public static boolean cloningMachineEnabled = true;
    @Node(category=Category.GENERAL, minValue=0.0)
    public static int lakeTrioMaxEnchants = 3;
    @Node(category=Category.GENERAL, nameOverride="engagePlayerByPokeBall")
    public static boolean pokeBallPlayerEngage = true;
    @Node(category=Category.GENERAL, minValue=0.0, maxValue=256.0, requiresRestart=true)
    public static int computerBoxes = 30;
    @Node(category=Category.GENERAL, nameOverride="enableWildAggression")
    public static boolean isAggressionAllowed = true;
    @Node(category=Category.GENERAL)
    public static boolean allowTMReuse = false;
    @Node(category=Category.GENERAL)
    public static boolean writeEntitiesToWorld = false;
    @Node(category=Category.GENERAL)
    public static boolean reusableBirdShrines = false;
    @Node(category=Category.GENERAL, nameOverride="spawnersOpOnly")
    public static boolean opToUseSpawners = true;
    @Node(category=Category.GENERAL, nameOverride="npcEditorOpOnly")
    public static boolean opToUseNpcEditor = true;
    @Node(category=Category.GENERAL, nameOverride="tradersReusable")
    public static boolean reuseTraders = false;
    @Node(category=Category.GENERAL)
    public static int movesPerTutor = 20;
    @Node(category=Category.GENERAL, nameOverride="starterOnJoin")
    public static boolean giveStarter = true;
    @Node(category=Category.GENERAL, nameOverride="useSystemTimeForWorldTime")
    public static boolean useSystemWorldTime = false;
    @Node(category=Category.GENERAL, nameOverride="systemTimeSyncInterval", minValue=2.0)
    public static int timeUpdateInterval = 30;
    @Node(category=Category.GENERAL, minValue=0.0, maxValue=4.0, useSlider=true)
    public static EnumBattleAIMode battleAIWild = EnumBattleAIMode.Random;
    @Node(category=Category.GENERAL, minValue=0.0, maxValue=4.0, useSlider=true)
    public static EnumBattleAIMode battleAIBoss = EnumBattleAIMode.Aggressive;
    @Node(category=Category.GENERAL, minValue=0.0, maxValue=4.0, useSlider=true)
    public static EnumBattleAIMode battleAITrainer = EnumBattleAIMode.Tactical;
    @Node(category=Category.GENERAL, minValue=0.0)
    public static float expModifier = 1.0f;
    @Node(category=Category.GENERAL, nameOverride="multiplePhotosOfSamePokemon")
    public static boolean allowMultiplePhotosOfSamePokemon = true;
    @Node(category=Category.GENERAL)
    public static boolean allowHappyHour = true;
    @Node(category=Category.GENERAL)
    public static boolean allowPayDay = true;
    @Node(category=Category.GENERAL)
    public static double payDayMultiplier = 5.0;
    @Node(category=Category.GENERAL)
    public static boolean allowAmuletCoin = true;
    @Node(category=Category.GENERAL, minValue=0.0)
    public static int pickupRate = 10;
    @Node(category=Category.GENERAL)
    public static boolean bedsHealPokemon = true;
    @Node(category=Category.GENERAL)
    public static boolean allowPokemonEditors = true;
    @Node(category=Category.GENERAL)
    public static boolean allowChisels = true;
    @Node(category=Category.GENERAL)
    public static boolean dataSaveOnWorldSave = true;
    @Node(category=Category.GENERAL)
    public static boolean useDropGUI = true;
    @Node(category=Category.GENERAL, minValue=0.10000000149011612, maxValue=1000.0)
    public static float berryTreeGrowthMultiplier = 1.0f;
    @Node(category=Category.GENERAL)
    public static boolean useSystemTimeForBerries = false;
    @Node(category=Category.GENERAL, minValue=1.0)
    public static int maxLevel = 100;
    @Node(category=Category.GENERAL, minValue=1.0)
    public static int despawnRadius = 80;
    @Node(category=Category.GENERAL)
    public static boolean canPokemonBeHit = false;
    @Node(category=Category.GENERAL, requiresRestart=true)
    public static boolean alwaysHaveMegaRing = false;
    @Node(category=Category.GENERAL, requiresRestart=true)
    public static boolean alwaysHaveDynamaxBand = false;
    @Node(category=Category.GENERAL)
    public static boolean deleteUnwantedDrops = false;
    @Node(category=Category.GENERAL)
    public static int chanceToGetSpecialBidoof = 30;
    @Node(category=Category.GENERAL)
    public static boolean disabledNonPlayerPixelmonMovement = false;
    @Node(category=Category.GENERAL)
    public static boolean allowShinyCharmFromPokedex = true;
    @Node(category=Category.GENERAL, type=String.class)
    public static List<String> oreColors = Lists.newArrayList((Object[])new String[]{"minecraft:iron_ore;E2C0AA;0", "minecraft:gold_ore;FCEE4B;0", "minecraft:redstone_ore;FF0000;0", "minecraft:emerald_ore;17DD62;1", "minecraft:diamond_ore;65F5E3;0", "minecraft:lapis_ore;1855BD;2", "minecraft:quartz_ore;EAE5DE;3", "pixelmon:amethyst_ore;9543A9;4", "pixelmon:sun_stone_ore;E57742;5", "pixelmon:silicon_ore;E2DFEE;0", "pixelmon:sapphire_ore;4A73E7;1", "pixelmon:ruby_ore;DD1C33;1", "pixelmon:fossil;443D32;6", "pixelmon:crystal_ore;AFEEEE;4", "pixelmon:bauxite_ore;D1B584;0", "pixelmon:dawn_dusk_ore;000000;7", "pixelmon:water_stone_ore;5D719F;8", "pixelmon:thunder_stone_ore;F0FF01;9", "pixelmon:leaf_stone_ore;7EA167;10", "pixelmon:fire_stone_ore;CC7132;11"});
    @Node(category=Category.GENERAL)
    public static int averageLureExpiryTicks = 17920;
    @Node(category=Category.GENERAL)
    public static boolean limitShopKeeperStackSize = false;
    @Node(category=Category.GENERAL, type=Integer.class)
    public static List<Integer> oldGenDimensions = Lists.newArrayList((Object[])new Integer[]{72});
    @Node(category=Category.GENERAL, minValue=1.0)
    public static float dynamaxScale = 1.6f;
    @Node(category=Category.GENERAL)
    public static boolean verbose = false;
    @Node(category=Category.HEALING)
    public static boolean usePassiveHealer = true;
    @Node(category=Category.HEALING)
    public static float chanceToRevivePassively = 0.001f;
    @Node(category=Category.HEALING)
    public static float chanceToHealStatusPassively = 0.005f;
    @Node(category=Category.HEALING)
    public static int stepsToHealHealthPassively = 75;
    @Node(category=Category.HEALING)
    public static float passiveHealingMaxHealthPercentage = 0.25f;
    @Node(category=Category.OUTSIDEEFFECTS)
    public static boolean useOutsideEffects = true;
    @Node(category=Category.OUTSIDEEFFECTS)
    public static int stepsToApplyEffects = 15;
    @Node(category=Category.OUTSIDEEFFECTS)
    public static int poisonMaxDamage = 5;
    @Node(category=Category.SPAWNING, nameOverride="shinySpawnRate", minValue=0.0)
    public static float shinyRate = 4096.0f;
    @Node(category=Category.SPAWNING)
    public static float bossRate = 256.0f;
    @Node(category=Category.SPAWNING, minValue=0.0)
    public static int bossSpawnTicks = 10000;
    @Node(category=Category.SPAWNING, minValue=0.0, maxValue=1.0)
    public static float bossSpawnChance = 0.3f;
    @Node(category=Category.SPAWNING, minValue=0.0)
    public static int legendarySpawnTicks = 25000;
    @Node(category=Category.SPAWNING, minValue=0.0, maxValue=1.0)
    public static float legendarySpawnChance = 0.3f;
    @Node(category=Category.SPAWNING, minValue=0.0)
    public static float spawnTicksPlayerMultiplier = 0.01f;
    @Node(category=Category.SPAWNING)
    public static boolean spawnLevelsByDistance = false;
    @Node(category=Category.SPAWNING, minValue=5.0, maxValue=100.0)
    public static int maxLevelByDistance = 60;
    @Node(category=Category.SPAWNING, minValue=0.0)
    public static int distancePerLevel = 30;
    @Node(category=Category.SPAWNING)
    public static boolean spawnLevelsCloserToPlayerLevels = true;
    @Node(category=Category.SPAWNING)
    public static double transformToDittoOnCatch = 0.001;
    @Node(category=Category.SPAWNING)
    public static int meltanSpawnChance = 3072;
    @Node(category=Category.SPAWNING)
    public static double meltanTransformChance = 0.25;
    @Node(category=Category.SPAWNING, type=String.class)
    public static List<String> canTransformToDittoOnCatch = Lists.newArrayList((Object[])new String[]{"Pidgey", "Rattata", "Gastly", "Zubat", "Mankey", "Yanma", "Hoothoot", "Sentret", "Zigzagoon", "Gulpin", "Whismur", "Taillow", "Remoraid", "Starly"});
    @Node(category=Category.SPAWNING, nameOverride="hiddenAbilitySpawnRate", minValue=0.0)
    public static int hiddenAbilityRate = 150;
    @Node(category=Category.SPAWNING, nameOverride="allowLegendarySpawn")
    public static boolean allowLegendariesSpawn = true;
    @Node(category=Category.SPAWNING, nameOverride="displayLegendaryGlobalMessage")
    public static boolean doLegendaryEvent = true;
    @Node(category=Category.SPAWNING)
    public static boolean useRecentLevelMoves = false;
    @Node(category=Category.SPAWNING)
    public static boolean despawnOnFleeOrLoss = false;
    @Node(category=Category.SPAWNING)
    public static int entitiesPerPlayer = 45;
    @Node(category=Category.SPAWNING)
    public static int spawnsPerPass = 2;
    @Node(category=Category.SPAWNING)
    public static float spawnFrequency = 60.0f;
    @Node(category=Category.SPAWNING)
    public static float minimumDistanceBetweenSpawns = 15.0f;
    @Node(category=Category.SPAWNING)
    public static int minimumDistanceFromCentre = 18;
    @Node(category=Category.SPAWNING)
    public static int maximumDistanceFromCentre = 64;
    @Node(category=Category.SPAWNING)
    public static float horizontalTrackFactor = 80.0f;
    @Node(category=Category.SPAWNING)
    public static float verticalTrackFactor = 0.0f;
    @Node(category=Category.SPAWNING)
    public static int horizontalSliceRadius = 10;
    @Node(category=Category.SPAWNING)
    public static int verticalSliceRadius = 25;
    @Node(category=Category.SPAWNING)
    public static int maximumSpawnedPokemon = 3000;
    @Node(category=Category.SPAWNING, minValue=0.0, maxValue=1.0)
    public static double bellSuccessChance = 0.01;
    @Node(category=Category.SPAWNING, minValue=0.0)
    public static int bellInclusionRange = 10;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen1 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen2 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen3 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen4 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen5 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen6 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen7 = true;
    @Node(category=Category.SPAWNINGGENS)
    public static boolean Gen8 = true;
    @Node(category=Category.POKELOOT)
    public static boolean spawnNormal = true;
    @Node(category=Category.POKELOOT)
    public static boolean spawnHidden = true;
    @Node(category=Category.POKELOOT)
    public static boolean spawnGrotto = true;
    @Node(category=Category.POKELOOT, minValue=0.0, maxValue=3.0, useSlider=true)
    public static EnumPokelootRate spawnRate = EnumPokelootRate.NORMAL;
    @Node(category=Category.POKELOOT, minValue=0.0, maxValue=3.0, useSlider=true)
    public static EnumPokelootModes spawnMode = EnumPokelootModes.FCFS;
    @Node(category=Category.POKELOOT, nameOverride="timedLootReuseHours", minValue=0.0)
    public static int lootTime = 24;
    @Node(category=Category.AFKHANDLER, nameOverride="enableAFKHandler")
    public static boolean afkHandlerOn = false;
    @Node(category=Category.AFKHANDLER, nameOverride="afkActivateSeconds", minValue=0.0)
    public static int afkTimerActivateSeconds = 90;
    @Node(category=Category.AFKHANDLER, nameOverride="afkHandlerTurnSeconds", minValue=0.0)
    public static int afkTimerTurnSeconds = 15;
    @Node(category=Category.GRAPHICS, minValue=0.0)
    public static double renderDistanceWeight = 2.0;
    @Node(category=Category.GRAPHICS, nameOverride="namePlateRange", minValue=0.0, maxValue=3.0, useSlider=true)
    public static int nameplateRangeModifier = 1;
    @Node(category=Category.GRAPHICS, nameOverride="renderWildLevels")
    public static boolean renderWildLevels = true;
    @Node(category=Category.GRAPHICS)
    public static boolean showWildNames = true;
    @Node(category=Category.GRAPHICS, nameOverride="scalePokemonModels", minValue=0.0)
    public static boolean scaleModelsUp = true;
    @Node(category=Category.GRAPHICS, nameOverride="useSmoothShadingOnPokeBalls")
    public static boolean enableSmoothPokeballShading = true;
    @Node(category=Category.GRAPHICS, nameOverride="useSmoothShadingOnPokemon")
    public static boolean enableSmoothPokemonShading = true;
    @Node(category=Category.GRAPHICS, requiresRestart=true)
    public static boolean smoothAnimations = false;
    @Node(category=Category.GRAPHICS, nameOverride="showCurrentAttackTarget")
    public static boolean showTarget = true;
    @Node(category=Category.GRAPHICS)
    public static boolean drawHealthBars = false;
    @Node(category=Category.GRAPHICS)
    public static boolean useBattleCamera = true;
    @Node(category=Category.GRAPHICS)
    public static boolean playerControlCamera = true;
    @Node(category=Category.GRAPHICS)
    public static boolean onlyShowAttackEffectsToBattlers = true;
    @Node(category=Category.GRAPHICS, minValue=0.0)
    public static int rangeToDisplayAttackAnimations = 40;
    @Node(category=Category.GRAPHICS)
    public static boolean emissiveTextures = true;
    @Node(category=Category.GRAPHICS, minValue=1.0)
    public static int emissiveTexturesDistance = 32;
    @Node(category=Category.BREEDING)
    public static boolean allowBreeding = true;
    @Node(category=Category.BREEDING, minValue=0.0)
    public static int maxCumulativePokemonInRanch = 0;
    @Node(category=Category.BREEDING)
    public static boolean allowDittoDittoBreeding = true;
    @Node(category=Category.BREEDING)
    public static boolean allowRandomBreedingEggsToBeLegendary = false;
    @Node(category=Category.BREEDING)
    public static boolean useBreedingEnvironment = true;
    @Node(category=Category.BREEDING, minValue=0.0)
    public static int stepsPerEggCycle = 255;
    @Node(category=Category.BREEDING, nameOverride="numBreedingStages", minValue=0.0)
    public static int numBreedingLevels = 5;
    @Node(category=Category.BREEDING, minValue=20.0)
    public static int breedingTicks = 18000;
    @Node(category=Category.BREEDING)
    public static float ovalCharmMultiplier = 0.5f;
    @Node(category=Category.BREEDING)
    public static boolean allowRanchExpansion = true;
    @Node(category=Category.PIXELUTILITIES)
    public static boolean scaleGrassBattles = false;
    @Node(category=Category.PIXELUTILITIES, nameOverride="pokeGiftReusable")
    public static boolean pokegiftMany = false;
    @Node(category=Category.PIXELUTILITIES, nameOverride="pokeGiftHaveEvents")
    public static boolean doPokegiftEvents = true;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventPokeGiftLoad")
    public static boolean isPokegiftEvent = false;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventHasLegendaries")
    public static boolean pokegiftEventLegendaries = false;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventHasShinies")
    public static boolean pokegiftEventShinies = false;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventMaxPokemon", minValue=1.0, maxValue=10.0, useSlider=true)
    public static int pokegiftEventMaxPokes = 1;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventShinyRate", minValue=0.0, maxValue=100.0, useSlider=true)
    public static int pokegiftEventShinyRate = 10;
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventTime")
    public static String customPokegiftEventTime = "D/M";
    @Node(category=Category.PIXELUTILITIES, nameOverride="eventCoords", type=String.class)
    public static List<String> pokegiftEventCoords = Collections.singletonList("notConfigured");
    @Node(category=Category.EXTERNALMOVES)
    public static boolean allowExternalMoves = true;
    @Node(category=Category.EXTERNALMOVES)
    public static boolean allowDestructiveExternalMoves = true;
    @Node(category=Category.EXTERNALMOVES)
    public static float forageChance = 0.3f;
    @Node(category=Category.STARTERS)
    public static boolean useCustomStarters = false;
    @Node(category=Category.STARTERS, nameOverride="shiny")
    public static boolean shinyStarter = false;
    @Node(category=Category.STARTERS, nameOverride="level", minValue=1.0, maxValue=100.0, useSlider=true)
    public static int starterLevel = 5;
    @Node(category=Category.STARTERS, type=String.class)
    public static List<String> starterList = Arrays.asList("Bulbasaur", "Squirtle", "Charmander", "Chikorita", "Totodile", "Cyndaquil", "Treecko", "Mudkip", "Torchic", "Turtwig", "Piplup", "Chimchar", "Snivy", "Oshawott", "Tepig", "Chespin", "Froakie", "Fennekin", "Rowlet", "Popplio", "Litten", "Grookey", "Sobble", "Scorbunny");
    @Node(category=Category.RIDING)
    public static boolean allowRiding = true;
    @Node(category=Category.RIDING, minValue=0.0)
    public static float ridingSpeedMultiplier = 1.0f;
    @Node(category=Category.RIDING)
    public static boolean enablePointToSteer = true;
    @Node(category=Category.RIDING)
    public static boolean landMount = true;
    @Node(category=Category.RIDING)
    public static boolean requireHM = false;
    @Node(category=Category.POKERUS, nameOverride="pkrsEnabled")
    public static boolean pokerusEnabled = true;
    @Node(category=Category.POKERUS, nameOverride="pkrsSpawnRate", minValue=0.0)
    public static float pokerusRate = 12288.0f;
    @Node(category=Category.POKERUS, nameOverride="pkrsInformPlayers")
    public static boolean pokerusInformPlayers = true;
    @Node(category=Category.POKERUS, nameOverride="pkrsSpreadRate", minValue=-1.0)
    public static int pokerusSpreadRate = 5;
    @Node(category=Category.GENERAL, requiresRestart=true)
    public static boolean spawnStructures = true;
    @Node(category=Category.GENERAL, requiresRestart=true)
    public static boolean spawnBirdShrines = true;
    @Node(category=Category.GENERAL, requiresRestart=true)
    public static boolean spawnCelebiShrines = true;
    @Node(category=Category.SPAWNING, requiresRestart=true)
    public static boolean replaceMCVillagers = true;
    @Node(category=Category.SPAWNING, nameOverride="spawnPokeMarts", requiresRestart=true)
    public static boolean spawnPokemarts = true;
    @Node(category=Category.SPAWNING)
    public static boolean spawnZygardeCells = true;
    @Node(category=Category.SPAWNING, requiresRestart=true)
    public static boolean spawnGyms = true;
    @Node(category=Category.SPAWNING, requiresRestart=true)
    public static boolean injectIntoLootTables = true;
    @Node(category=Category.SPAWNING, type=String.class, requiresRestart=true)
    public static List<String> lootIgnoreList = Lists.newArrayList();
    @Node(category=Category.SPAWNING)
    public static double ilexShrineSpawnRate = 0.005;
    @Node(category=Category.ULTRASPACE)
    public static boolean ultraSpace = true;
    @Node(category=Category.ULTRASPACE)
    public static int ultraSpaceDimId = 0;
    @Node(category=Category.ULTRASPACE, minValue=0.0)
    public static float ultraSpaceShinyModifier = 0.5f;
    @Node(category=Category.ULTRASPACE, minValue=0.0)
    public static float ultraSpaceBossModifier = 0.5f;
    @Node(category=Category.ULTRASPACE, minValue=0.0)
    public static float ultraSpaceHiddenAbilityModifier = 0.5f;
    @Node(category=Category.ULTRASPACE)
    public static boolean ultraSpaceColourblindMode = false;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceExtraShrines = true;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceNetherForts = true;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceEndCities = true;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceExtraOres = true;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceExtraPlants = true;
    @Node(category=Category.ULTRASPACE)
    public static boolean spawnUltraSpaceExtraLoots = true;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesDrops = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesMoves = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesNPCs = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesRules = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesSpawning = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesStats = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesStructures = false;
    @Node(category=Category.EXTERNALFILES)
    public static boolean useExternalJSONFilesQuests = false;
    @Node(category=Category.EXTERNALFILES)
    public static String spawnSetFolder = "default";
    @Node(category=Category.EXTERNALFILES)
    public static boolean useBetterSpawnerConfig = false;
    @Node(category=Category.STORAGE)
    public static boolean useAsyncSaving = false;
    @Node(category=Category.STORAGE)
    public static int asyncInterval = 60;
    @Node(category=Category.ELEVATOR, minValue=1.0, maxValue=255.0, useSlider=true)
    public static int elevatorSearchRange = 10;
    @Node(category=Category.QUESTS)
    public static int questMaxRange = 500;
    @Node(category=Category.QUESTS)
    public static boolean questRandomNPCs = true;
    public static boolean allowWildPokemonFleeing = false;
    private static HoconConfigurationLoader configurationLoader;
    private static CommentedConfigurationNode mainNode;
    private static CommentedConfigurationNode defaults;

    public static void init(File configFile) {
        configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        if (defaults == null) {
            defaults = PixelmonConfig.configFromFields();
        }
        try {
            PixelmonConfig.reload();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void reload() throws IOException {
        mainNode = (CommentedConfigurationNode)configurationLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
        PixelmonConfig.load(mainNode);
    }

    public static void saveConfig() {
        try {
            CommentedConfigurationNode config = PixelmonConfig.configFromFields();
            configurationLoader.save(config);
            mainNode = (CommentedConfigurationNode)configurationLoader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static CommentedConfigurationNode getConfig() {
        return mainNode;
    }

    public static void disableEventLoading() {
        isPokegiftEvent = false;
        PixelmonConfig.saveConfig();
    }

    public static float getShinyRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return shinyRate * ultraSpaceShinyModifier;
        }
        return shinyRate;
    }

    public static float getBossRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return bossRate * ultraSpaceBossModifier;
        }
        return bossRate;
    }

    public static float getHiddenAbilityRate(int dimension) {
        if (dimension == UltraSpace.DIM_ID) {
            return (float)hiddenAbilityRate * ultraSpaceHiddenAbilityModifier;
        }
        return hiddenAbilityRate;
    }

    public static float getLegendaryRate() {
        return legendarySpawnChance;
    }

    public static double getGrowthModifier() {
        return growthModifier;
    }

    public static boolean isGenerationEnabled(int generation) {
        switch (generation) {
            case 1: {
                return Gen1;
            }
            case 2: {
                return Gen2;
            }
            case 3: {
                return Gen3;
            }
            case 4: {
                return Gen4;
            }
            case 5: {
                return Gen5;
            }
            case 6: {
                return Gen6;
            }
            case 7: {
                return Gen7;
            }
            case 8: {
                return Gen8;
            }
        }
        return false;
    }

    public static boolean allGenerationsDisabled() {
        return !Gen1 && !Gen2 && !Gen3 && !Gen4 && !Gen5 && !Gen6 && !Gen7 && !Gen8;
    }

    public static boolean allGenerationsEnabled() {
        return Gen1 && Gen2 && Gen3 && Gen4 && Gen5 && Gen6 && Gen7 && Gen8;
    }

    public static boolean checkMigrations(CommentedConfigurationNode configNode) {
        boolean shouldSave = false;
        if (configNode.hasMapChildren()) {
            for (CommentedConfigurationNode commentedConfigurationNode : configNode.getChildrenMap().values()) {
                shouldSave = PixelmonConfig.checkMigrations(commentedConfigurationNode) || shouldSave;
            }
        }
        shouldSave = ConfigMigrationHandler.handleMigration(configNode) || shouldSave;
        return shouldSave;
    }

    public static int getRandomEnabledGeneration() {
        if (PixelmonConfig.allGenerationsEnabled()) {
            return RandomHelper.getRandomNumberBetween(1, 8);
        }
        if (PixelmonConfig.allGenerationsDisabled()) {
            throw new IllegalStateException();
        }
        ArrayList<Integer> generations = new ArrayList<Integer>();
        if (Gen1) {
            generations.add(1);
        }
        if (Gen2) {
            generations.add(2);
        }
        if (Gen3) {
            generations.add(3);
        }
        if (Gen4) {
            generations.add(4);
        }
        if (Gen5) {
            generations.add(5);
        }
        if (Gen6) {
            generations.add(6);
        }
        if (Gen7) {
            generations.add(7);
        }
        if (Gen8) {
            generations.add(8);
        }
        return (Integer)generations.get(RandomHelper.getRandomNumberBetween(0, generations.size() - 1));
    }

    public static int getShopMaxStackSize(ItemStack stack) {
        if (limitShopKeeperStackSize) {
            return stack == null ? 64 : stack.func_77976_d();
        }
        return 2304;
    }

    private static void load(CommentedConfigurationNode config) {
        for (String category : Category.getTitles()) {
            CommentedConfigurationNode categoryNode = config;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            categoryNode.setComment(I18n.func_74838_a((String)("pixelmon.config." + category.toLowerCase() + ".comment")));
        }
        for (Field field : PixelmonConfig.class.getDeclaredFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Node.class) == null) continue;
            Node node = field.getAnnotation(Node.class);
            String category = node.category().getTitle();
            String name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
            String comment = "pixelmon.config." + name + ".comment";
            CommentedConfigurationNode categoryNode = config;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            CommentedConfigurationNode configNode = categoryNode.getNode(name);
            configNode.setComment(I18n.func_74838_a((String)comment));
            PixelmonConfig.set(field, configNode, node);
        }
        Pixelmon.LOGGER.info("Checking for migrations..");
        if (PixelmonConfig.checkMigrations(PixelmonConfig.getConfig())) {
            PixelmonConfig.saveConfig();
        }
        PixelmonServerConfig.load();
        PixelmonConfig.saveConfig();
    }

    private static void set(Field field, CommentedConfigurationNode configNode, Node node) {
        try {
            Class<?> type = field.getType();
            if (type == Boolean.TYPE) {
                boolean value = configNode.getBoolean(field.getBoolean(null));
                field.setBoolean(null, value);
            } else if (type == Integer.TYPE) {
                int value = configNode.getInt(field.getInt(null));
                value = (double)value < node.minValue() ? (int)node.minValue() : ((double)value > node.maxValue() ? (int)node.maxValue() : value);
                field.setInt(null, value);
            } else if (type == Float.TYPE) {
                float value = configNode.getFloat(field.getFloat(null));
                value = (double)value < node.minValue() ? (float)node.minValue() : ((double)value > node.maxValue() ? (float)node.maxValue() : value);
                field.setFloat(null, value);
            } else if (type == Double.TYPE) {
                double value = configNode.getDouble(field.getDouble(null));
                value = value < node.minValue() ? node.minValue() : (value > node.maxValue() ? node.maxValue() : value);
                field.setDouble(null, value);
            } else if (type == String.class) {
                String value = configNode.getString((String)field.get(null));
                field.set(null, value);
            } else if (type == List.class) {
                List value = configNode.getList(TypeToken.of(node.type()), (List)field.get(null));
                field.set(null, value);
            } else if (Enum.class.isAssignableFrom(type)) {
                field.set(null, type.getEnumConstants()[configNode.getInt(((Enum)field.get(null)).ordinal())]);
            } else {
                Pixelmon.LOGGER.error("Cannot read config value " + configNode.getKey());
            }
        }
        catch (ObjectMappingException | IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static CommentedConfigurationNode configFromFields() {
        if (configurationLoader == null) {
            throw new NullPointerException("Configuration loader null, configFromFields() called to early!");
        }
        CommentedConfigurationNode emptyNode = configurationLoader.createEmptyNode(ConfigurationOptions.defaults());
        for (String category : Category.getTitles()) {
            CommentedConfigurationNode categoryNode = emptyNode;
            for (String cat : category.split("\\.")) {
                categoryNode = categoryNode.getNode(cat);
            }
            categoryNode.setComment(I18n.func_74838_a((String)("pixelmon.config." + category.toLowerCase() + ".comment")));
        }
        try {
            for (Field field : PixelmonConfig.class.getDeclaredFields()) {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Node.class) == null) continue;
                Node node = field.getAnnotation(Node.class);
                String category = node.category().getTitle();
                String name = node.nameOverride().isEmpty() ? field.getName() : node.nameOverride();
                String comment = "pixelmon.config." + name + ".comment";
                CommentedConfigurationNode categoryNode = emptyNode;
                for (String cat : category.split("\\.")) {
                    categoryNode = categoryNode.getNode(cat);
                }
                CommentedConfigurationNode configNode = categoryNode.getNode(name);
                configNode.setComment(I18n.func_74838_a((String)comment));
                if (Enum.class.isAssignableFrom(field.getType())) {
                    configNode.setValue(((Enum)field.get(null)).ordinal());
                    continue;
                }
                configNode.setValue(field.get(null));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return emptyNode;
    }

    public static enum Category {
        GENERAL("General", true, false),
        SPAWNING("Spawning", true, false),
        SPAWNINGGENS("Spawning.Gens", true, false),
        POKELOOT("PokeLoot", true, false),
        AFKHANDLER("AFKHandler", true, false),
        GRAPHICS("Graphics", true, false),
        BREEDING("Breeding", true, false),
        PIXELUTILITIES("PixelUtilities", true, false),
        EXTERNALMOVES("ExternalMoves", true, false),
        POKERUS("Pokerus", true, false),
        ULTRASPACE("UltraSpace", true, false),
        STORAGE("Storage", false, false),
        STARTERS("Starters", true, false),
        ELEVATOR("Elevator", true, false),
        HEALING("Healing", true, false),
        RIDING("Riding", true, false),
        OUTSIDEEFFECTS("OutsideEffects", true, false),
        EXTERNALFILES("ExternalFiles", true, true),
        QUESTS("Quests", true, true);

        private final String title;
        private final boolean showInGui;
        private final boolean requiresMcRestart;

        private Category(String title, boolean showInGui, boolean requiresMcRestart) {
            this.title = title;
            this.showInGui = showInGui;
            this.requiresMcRestart = requiresMcRestart;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean shouldShowInGui() {
            return this.showInGui;
        }

        public boolean requiresMcRestart() {
            return this.requiresMcRestart;
        }

        public static List<String> getTitles() {
            return Arrays.stream(Category.values()).map(Category::getTitle).collect(Collectors.toList());
        }
    }
}

