/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities;

import java.util.ArrayList;
import net.minecraft.util.text.translation.I18n;

public enum SpawnLocationType {
    Land,
    LandNPC,
    LandVillager,
    Water,
    UnderGround,
    Air,
    AirPersistent,
    Legendary,
    Boss;


    public static SpawnLocationType[] getSpawnLocations(ArrayList<String> list) {
        SpawnLocationType[] locations = new SpawnLocationType[list.size()];
        int i = 0;
        for (String s : list) {
            for (SpawnLocationType sp : SpawnLocationType.values()) {
                if (!sp.toString().equalsIgnoreCase(s)) continue;
                locations[i++] = sp;
            }
        }
        return locations;
    }

    public static SpawnLocationType getSpawnLocation(String location) {
        for (SpawnLocationType sp : SpawnLocationType.values()) {
            if (!sp.toString().equalsIgnoreCase(location)) continue;
            return sp;
        }
        return null;
    }

    public static SpawnLocationType getFromIndex(int integer) {
        try {
            return SpawnLocationType.values()[integer];
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public static SpawnLocationType nextLocation(SpawnLocationType spawnLocation) {
        switch (spawnLocation) {
            case Land: {
                return Water;
            }
            case AirPersistent: {
                return Land;
            }
        }
        return SpawnLocationType.getFromIndex((spawnLocation.ordinal() + 1) % SpawnLocationType.values().length);
    }

    public static boolean contains(SpawnLocationType[] locations, SpawnLocationType location) {
        for (SpawnLocationType l : locations) {
            if (l != location) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnly(SpawnLocationType[] locations, SpawnLocationType location) {
        if (locations.length == 1) {
            return SpawnLocationType.contains(locations, location);
        }
        return false;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)("enum.spawnlocation." + this.toString().toLowerCase()));
    }
}

