/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Hail;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import com.pixelmonmod.pixelmon.enums.forms.EnumEiscue;

public class IceFace
extends AbilityBase {
    boolean busted = false;

    @Override
    public int modifyDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (target.getSpecies() != EnumSpecies.Eiscue) {
            return damage;
        }
        if (target.getFormEnum() == EnumEiscue.ICE_FACE && a.getAttackCategory() == AttackCategory.PHYSICAL && !this.busted) {
            target.bc.sendToAll("pixelmon.abilities.iceface.protected", target.getNickname());
            if (!target.bc.simulateMode) {
                this.busted = true;
            }
            return 0;
        }
        return damage;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.getSpecies() != EnumSpecies.Eiscue) {
            return;
        }
        if (newPokemon.getFormEnum() == EnumEiscue.NOICE_FACE && newPokemon.bc.globalStatusController.getWeather() instanceof Hail && !newPokemon.bc.simulateMode) {
            newPokemon.bc.sendToAll("pixelmon.abilities.iceface.restore", newPokemon.getNickname());
            newPokemon.setForm(EnumEiscue.ICE_FACE);
            this.busted = false;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (pokemon.getSpecies() != EnumSpecies.Eiscue) {
            return;
        }
        if (this.busted && pokemon.getFormEnum() == EnumEiscue.ICE_FACE) {
            pokemon.setForm(EnumEiscue.NOICE_FACE);
        }
    }

    @Override
    public void onWeatherChange(PixelmonWrapper pw, Weather weather) {
        if (pw.getSpecies() != EnumSpecies.Eiscue) {
            return;
        }
        if (pw.getFormEnum() == EnumEiscue.NOICE_FACE && weather instanceof Hail && !pw.bc.simulateMode) {
            pw.bc.sendToAll("pixelmon.abilities.iceface.restore", pw.getNickname());
            pw.setForm(EnumEiscue.ICE_FACE);
            this.busted = false;
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

