/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.IVStore;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class SetAllIVsEVsFlag
extends SpecValue<Void>
implements ISpecType {
    public List<String> keys;
    public int amount = 0;
    public boolean isIVs;

    public SetAllIVsEVsFlag(List<String> keys, boolean isIVs, int amount) {
        super(keys.get(0), null);
        this.keys = keys;
        this.isIVs = isIVs;
        this.amount = amount;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        return new SetAllIVsEVsFlag(this.keys, this.isIVs, this.amount);
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return new SetAllIVsEVsFlag(this.keys, this.isIVs, this.amount);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74757_a(this.key, true);
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return SetAllIVsEVsFlag.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return this.key;
    }

    @Override
    public Class<Void> getValueClass() {
        return Void.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        if (this.isIVs) {
            pokemon.getIVs().CopyIVs(new IVStore(new int[]{this.amount, this.amount, this.amount, this.amount, this.amount, this.amount}));
        } else {
            pokemon.getEVs().fillFromArray(new int[]{this.amount, this.amount, this.amount, this.amount, this.amount, this.amount});
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        int[] arr = new int[]{this.amount, this.amount, this.amount, this.amount, this.amount, this.amount};
        return this.isIVs ? pokemon.getIVs().getArray() == arr : pokemon.getEVs().getArray() == arr;
    }

    @Override
    public SpecValue<Void> clone() {
        return new SetAllIVsEVsFlag(this.keys, this.isIVs, this.amount);
    }
}

