/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.AttackTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.MountedFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvoConditionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.LevelCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.ExperienceGroup;
import com.pixelmonmod.pixelmon.enums.ITechnicalMove;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.SoundEvent;

public class BaseStats {
    public static final transient Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Evolution.class, (Object)new EvolutionTypeAdapter()).registerTypeAdapter(EvoCondition.class, (Object)new EvoConditionTypeAdapter()).registerTypeAdapter(Attack.class, (Object)new AttackTypeAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).registerTypeHierarchyAdapter(ITechnicalMove.class, (Object)new ITechnicalMove.Adapter()).create();
    public static final transient EnumMap<EnumSpecies, BaseStats> allBaseStats = Maps.newEnumMap(EnumSpecies.class);
    public String pixelmonName;
    public EnumSpecies pokemon;
    public int form = 0;
    public transient int nationalPokedexNumber;
    public LinkedHashMap<StatsType, Integer> stats = null;
    public Integer catchRate = null;
    public Integer malePercent = null;
    public Integer spawnLevel = null;
    public Integer spawnLevelRange = null;
    public Integer baseExp = null;
    public Integer baseFriendship = null;
    public ArrayList<EnumType> types = null;
    public Float height = null;
    public Float width = null;
    public Float length = null;
    public Boolean isRideable = null;
    public Boolean canFly = null;
    public Boolean canSurf = null;
    public Boolean canShoulder = null;
    public String[] preEvolutions = null;
    public transient PokemonSpec[] specPreEvolutions = null;
    public transient EnumSpecies[] legacyPreEvolutions = null;
    public ExperienceGroup experienceGroup = null;
    public Aggression aggression = null;
    public SwimmingParameters swimmingParameters = null;
    public FlyingParameters flyingParameters = null;
    public MountedFlying mountedFlying = null;
    public SpawnLocationType[] spawnLocations = null;
    public LinkedHashMap<StatsType, Integer> evYields = null;
    public RidingOffsets ridingOffsets = null;
    public Float hoverHeight = null;
    public Float weight = null;
    public ArrayList<Evolution> evolutions = null;
    public String[] abilities = null;
    public EnumEggGroup[] eggGroups = null;
    public Integer eggCycles = null;
    public LinkedHashMap<Integer, ArrayList<Attack>> levelUpMoves = null;
    public ArrayList<Attack> tmMoves = null;
    public ArrayList<Attack> tutorMoves = null;
    public ArrayList<Attack> eggMoves = null;
    private List<ITechnicalMove.Gen8TechnicalMachines> tmMoves8 = null;
    private List<ITechnicalMove.Gen8TechnicalRecords> trMoves = null;
    public transient int id;
    public transient int baseFormID;
    public LinkedHashMap<Integer, BaseStats> forms = null;
    public transient BaseStats parent = null;
    private final transient HashMap<SoundType, ArrayList<SoundEvent>> sounds = new HashMap();
    private transient boolean[] soundRegistered = new boolean[]{false, false, false};
    public transient int minLevel = 1;
    public transient int maxLevel = PixelmonServerConfig.maxLevel;

    public static void loadAllBaseStats() {
        Pixelmon.LOGGER.info("Registering Pok\u00e9mon stats.");
        if (PixelmonConfig.useExternalJSONFilesStats) {
            new File("./pixelmon/stats/").mkdirs();
        }
        for (EnumSpecies pokemon : EnumSpecies.values()) {
            try {
                if (!PixelmonConfig.useExternalJSONFilesStats) {
                    allBaseStats.put(pokemon, BaseStats.getBaseStatsFromAssets(pokemon));
                    continue;
                }
                File file = new File("./pixelmon/stats/" + pokemon.name() + ".json");
                if (!file.exists()) {
                    String path = "/assets/pixelmon/stats/" + pokemon.getNationalPokedexNumber() + ".json";
                    try (InputStream iStream = BaseStats.class.getResourceAsStream(path);){
                        Files.copy(iStream, file.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (file.exists()) {
                    try (FileReader reader = new FileReader(file);){
                        BaseStats bs = (BaseStats)GSON.fromJson((Reader)reader, BaseStats.class);
                        bs.preEvolutions = bs.preEvolutions == null ? new String[]{} : bs.preEvolutions;
                        bs.nationalPokedexNumber = pokemon.getNationalPokedexInteger();
                        ArrayList<EnumSpecies> legacyPreEvolutions = new ArrayList<EnumSpecies>();
                        ArrayList<PokemonSpec> specPreEvolutions = new ArrayList<PokemonSpec>();
                        for (String preEvolution : bs.preEvolutions) {
                            PokemonSpec spec = new PokemonSpec(preEvolution.split(" "));
                            if (spec == null) continue;
                            Optional<EnumSpecies> s = EnumSpecies.getFromName(spec.name);
                            if (!s.isPresent() || s.get() == null) {
                                Pixelmon.LOGGER.error("Found Invalid pokemonSpec in preEvolutions for " + pokemon.name() + ".json matching \"" + spec.toString() + "\"");
                                continue;
                            }
                            legacyPreEvolutions.add(s.get());
                            specPreEvolutions.add(spec);
                        }
                        bs.specPreEvolutions = new PokemonSpec[specPreEvolutions == null ? 0 : specPreEvolutions.size()];
                        specPreEvolutions.toArray(bs.specPreEvolutions);
                        bs.legacyPreEvolutions = new EnumSpecies[legacyPreEvolutions == null ? 0 : legacyPreEvolutions.size()];
                        legacyPreEvolutions.toArray(bs.legacyPreEvolutions);
                        if (bs.forms != null && !bs.forms.isEmpty()) {
                            for (BaseStats formBS : bs.forms.values()) {
                                formBS.expand(bs);
                            }
                        }
                        allBaseStats.put(pokemon, bs);
                    }
                    catch (Exception e) {
                        Pixelmon.LOGGER.error("Could not load external base stat file {}, Loading internal instead", (Object)file.getPath());
                        e.printStackTrace();
                        allBaseStats.put(pokemon, BaseStats.getBaseStatsFromAssets(pokemon));
                    }
                    continue;
                }
                Pixelmon.LOGGER.warn("Failed to export base stat file {}, Loading internal instead", (Object)file.getPath());
                allBaseStats.put(pokemon, BaseStats.getBaseStatsFromAssets(pokemon));
            }
            catch (Exception e) {
                Pixelmon.LOGGER.error("Could not load base stats for {}, file: {}.json, external: {}", (Object)pokemon.getPokemonName(), (Object)(PixelmonConfig.useExternalJSONFilesStats ? pokemon.getPokemonName() : pokemon.getNationalPokedexNumber()), (Object)PixelmonConfig.useExternalJSONFilesStats);
                e.printStackTrace();
            }
        }
        for (BaseStats bs : allBaseStats.values()) {
            if (bs.forms != null) {
                for (BaseStats formBS : bs.forms.values()) {
                    for (Attack a : formBS.getTutorMoves()) {
                        AttackBase ab = a.getActualMove();
                        if (NPCTutor.allTutorMoves.contains(ab)) continue;
                        NPCTutor.allTutorMoves.add(ab);
                    }
                }
            }
            for (Attack a : bs.getTutorMoves()) {
                AttackBase ab = a.getActualMove();
                if (NPCTutor.allTutorMoves.contains(ab)) continue;
                NPCTutor.allTutorMoves.add(ab);
            }
            bs.calculateMinMaxLevels();
            if (bs.forms == null) continue;
            for (BaseStats stats2 : bs.forms.values()) {
                stats2.calculateMinMaxLevels();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BaseStats getBaseStatsFromAssets(EnumSpecies species) throws IOException {
        String path = "/assets/pixelmon/stats/" + species.getNationalPokedexNumber() + ".json";
        try (InputStreamReader reader = new InputStreamReader(BaseStats.class.getResourceAsStream(path));){
            BaseStats bs = (BaseStats)GSON.fromJson((Reader)reader, BaseStats.class);
            bs.nationalPokedexNumber = species.getNationalPokedexInteger();
            if (bs.forms != null && !bs.forms.isEmpty()) {
                for (BaseStats formBS : bs.forms.values()) {
                    formBS.expand(bs);
                }
            }
            bs.preEvolutions = bs.preEvolutions == null ? new String[]{} : bs.preEvolutions;
            ArrayList<EnumSpecies> legacyPreEvolutions = new ArrayList<EnumSpecies>();
            ArrayList<PokemonSpec> specPreEvolutions = new ArrayList<PokemonSpec>();
            for (String preEvolution : bs.preEvolutions) {
                PokemonSpec spec = new PokemonSpec(preEvolution.split(" "));
                if (spec == null) continue;
                Optional<EnumSpecies> s = EnumSpecies.getFromName(spec.name);
                if (!s.isPresent() || s.get() == null) {
                    Pixelmon.LOGGER.error("Found Invalid pokemonSpec in preEvolutions for " + species.getNationalPokedexNumber() + ".json matching \"" + spec.toString() + "\"");
                    continue;
                }
                legacyPreEvolutions.add(s.get());
                specPreEvolutions.add(spec);
            }
            bs.specPreEvolutions = new PokemonSpec[specPreEvolutions == null ? 0 : specPreEvolutions.size()];
            specPreEvolutions.toArray(bs.specPreEvolutions);
            bs.legacyPreEvolutions = new EnumSpecies[legacyPreEvolutions == null ? 0 : legacyPreEvolutions.size()];
            legacyPreEvolutions.toArray(bs.legacyPreEvolutions);
            BaseStats baseStats = bs;
            return baseStats;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Couldn't load internal stat JSON: " + path);
            throw e;
        }
    }

    BaseStats() {
    }

    public BaseStats getParent() {
        return this.parent == null ? this : this.parent;
    }

    public int get(StatsType stat) {
        return this.stats.getOrDefault(stat, -1);
    }

    public void expand(BaseStats comparison) {
        this.nationalPokedexNumber = comparison.nationalPokedexNumber;
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                if (f.getName().equals("forms")) continue;
                Object o1 = f.get(this);
                Object o2 = f.get(comparison);
                if (o1 != null || o2 == null) continue;
                f.set(this, o2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addSound(SoundType type, SoundEvent sound) {
        if (!this.soundRegistered[type.ordinal()]) {
            ArrayList stats = Lists.newArrayList((Object[])new BaseStats[]{this});
            if (this.forms != null) {
                stats.addAll(this.forms.values());
            }
            for (BaseStats form : stats) {
                ArrayList<Object> list = form.sounds.get((Object)type);
                if (list == null) {
                    list = new ArrayList();
                }
                list.add(sound);
                form.sounds.put(type, list);
                form.soundRegistered[type.ordinal()] = true;
            }
        }
    }

    public SoundEvent getSound(SoundType type) {
        ArrayList<SoundEvent> list = this.sounds.get((Object)type);
        if (list == null) {
            return null;
        }
        return RandomHelper.getRandomElementFromList(list);
    }

    private boolean hasSound(SoundType type) {
        return this.sounds.containsKey((Object)type);
    }

    public boolean hasSoundForGender(Gender gender) {
        return this.sounds.containsKey((Object)(gender == Gender.Male ? SoundType.Male : SoundType.Female)) || this.sounds.containsKey((Object)SoundType.Neutral);
    }

    public SoundEvent getSoundForGender(Gender gender) {
        if (gender == Gender.Male) {
            if (this.hasSound(SoundType.Male)) {
                return this.getSound(SoundType.Male);
            }
        } else if (gender == Gender.Female && this.hasSound(SoundType.Female)) {
            return this.getSound(SoundType.Female);
        }
        if (this.hasSound(SoundType.Neutral)) {
            return this.getSound(SoundType.Neutral);
        }
        return null;
    }

    public void calculateMinMaxLevels() {
        this.maxLevel = this.getHighestFeasibleLevel();
        if (this.maxLevel == -1) {
            this.maxLevel = PixelmonServerConfig.maxLevel;
        }
        this.minLevel = 1;
        if (this.legacyPreEvolutions != null && this.legacyPreEvolutions.length > 0) {
            for (EnumSpecies preEvo : this.legacyPreEvolutions) {
                try {
                    BaseStats preEvoBS;
                    if (preEvo == null) continue;
                    IEnumForm formEnum = preEvo.getFormEnum(this.form);
                    if (formEnum == null) {
                        formEnum = EnumNoForm.NoForm;
                    }
                    if ((preEvoBS = preEvo.getBaseStats(formEnum)) == null) break;
                    int level = preEvoBS.getHighestFeasibleLevel();
                    if (level <= this.minLevel) continue;
                    this.minLevel = level;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.maxLevel < this.minLevel) {
            this.minLevel = this.maxLevel;
        }
    }

    public int getHighestFeasibleLevel() {
        int maxLevel = -1;
        if (this.evolutions != null && !this.evolutions.isEmpty()) {
            for (Evolution evolution : this.evolutions) {
                int level;
                if (evolution == null) continue;
                if (evolution instanceof LevelingEvolution && (level = ((LevelingEvolution)evolution).getLevel()) > maxLevel) {
                    maxLevel = level;
                }
                for (LevelCondition condition : evolution.getConditionsOfType(LevelCondition.class)) {
                    if (condition.level <= maxLevel) continue;
                    maxLevel = condition.level;
                }
            }
        }
        return maxLevel;
    }

    public boolean hovers() {
        return this.hoverHeight != null && this.hoverHeight.floatValue() > 0.0f;
    }

    public boolean hasEggGroup(EnumEggGroup eggGroupTarget) {
        for (EnumEggGroup eggGroup : this.eggGroups) {
            if (eggGroup != eggGroupTarget) continue;
            return true;
        }
        return false;
    }

    public List<EnumType> getTypeList() {
        return this.types;
    }

    public EnumType getType1() {
        return this.types.get(0);
    }

    public EnumType getType2() {
        return this.types.size() > 1 ? this.types.get(1) : null;
    }

    public static ArrayList<Attack> severReferences(ArrayList<Attack> attacks) {
        ArrayList<Attack> newAttacks = new ArrayList<Attack>(attacks.size());
        for (Attack oldAttack : attacks) {
            if (oldAttack == null) continue;
            newAttacks.add(new Attack(oldAttack.getActualMove()));
        }
        return newAttacks;
    }

    public ArrayList<Attack> getMovesUpToLevel(int level) {
        ArrayList<Attack> attacks = new ArrayList<Attack>();
        for (int i = 0; i <= level; ++i) {
            if (this.levelUpMoves == null || !this.levelUpMoves.containsKey(i)) continue;
            for (Attack attack : this.levelUpMoves.get(i)) {
                if (attacks.contains(attack)) continue;
                attacks.add(attack);
            }
        }
        return BaseStats.severReferences(attacks);
    }

    public ArrayList<Attack> getMovesAtLevel(int level) {
        if (this.levelUpMoves != null && this.levelUpMoves.containsKey(level)) {
            return new ArrayList<Attack>(BaseStats.severReferences(this.levelUpMoves.get(level)));
        }
        return new ArrayList<Attack>();
    }

    public Moveset loadMoveset(int level) {
        ArrayList<Attack> attackList = this.getMovesUpToLevel(level);
        while (attackList.size() > 4) {
            if (PixelmonConfig.useRecentLevelMoves) {
                attackList.remove(0);
                continue;
            }
            RandomHelper.removeRandomElementFromList(attackList);
        }
        if (attackList.isEmpty()) {
            attackList.add(new Attack("Tackle"));
        }
        Moveset moveset = new Moveset();
        moveset.addAll(BaseStats.severReferences(attackList));
        return moveset;
    }

    public ArrayList<Attack> getTMHMMoves() {
        if (this.tmMoves != null) {
            return BaseStats.severReferences(this.tmMoves);
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getTutorMoves() {
        if (this.tutorMoves != null) {
            return BaseStats.severReferences(this.tutorMoves);
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getEggMoves() {
        if (this.eggMoves != null) {
            return BaseStats.severReferences(this.eggMoves);
        }
        return new ArrayList<Attack>();
    }

    public List<ITechnicalMove> getTMMoves() {
        if (this.tmMoves8 == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.tmMoves8);
    }

    public List<ITechnicalMove> getTrMoves() {
        if (this.trMoves == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.trMoves);
    }

    public ArrayList<Attack> getAllMoves() {
        ArrayList<Attack> moves = new ArrayList<Attack>();
        if (this.levelUpMoves != null && !this.levelUpMoves.isEmpty()) {
            for (Map.Entry<Integer, ArrayList<Attack>> entry : this.levelUpMoves.entrySet()) {
                moves.addAll(BaseStats.severReferences(entry.getValue()));
            }
        }
        moves.addAll(this.getTMHMMoves());
        moves.addAll(this.getTutorMoves());
        moves.addAll(this.getEggMoves());
        ArrayList<Attack> distinctMoves = new ArrayList<Attack>();
        for (Attack attack : moves) {
            if (distinctMoves.contains(attack)) continue;
            distinctMoves.add(attack);
        }
        return distinctMoves;
    }

    public boolean canLearn(String attackName) {
        ArrayList<Attack> allMoves = this.getAllMoves();
        for (Attack attack : allMoves) {
            if (!attack.isAttack(attackName)) continue;
            return true;
        }
        return false;
    }

    public static enum SoundType {
        Neutral,
        Male,
        Female;

    }
}

