/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats.links;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.LevelUp;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Stats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumNature;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DelegateLink
extends PokemonLink {
    public Pokemon pokemon;

    public DelegateLink(Pokemon pokemon) {
        this.pokemon = pokemon;
    }

    @Override
    public Pokemon getPokemon() {
        return this.pokemon;
    }

    @Override
    public Stats getStats() {
        return this.pokemon.getStats();
    }

    @Override
    public ItemHeld getHeldItem() {
        return this.pokemon.getHeldItemAsItemHeld();
    }

    @Override
    public void setHeldItem(ItemStack item) {
        this.pokemon.setHeldItem(item);
    }

    @Override
    public int getHealth() {
        return this.pokemon.getHealth();
    }

    @Override
    public int getMaxHealth() {
        return this.getMaxHealth(false);
    }

    @Override
    public int getMaxHealth(boolean ignoreDynamax) {
        return this.pokemon.getMaxHealth();
    }

    @Override
    public void setHealth(int health) {
        this.pokemon.setHealth(health);
    }

    @Override
    public int getLevel() {
        return this.pokemon.getLevel();
    }

    @Override
    public void setLevel(int level) {
        this.pokemon.setLevelNum(level);
    }

    @Override
    public int getExp() {
        return this.pokemon.getExperience();
    }

    @Override
    public void setExp(int experience) {
        this.pokemon.setExperience(experience);
    }

    @Override
    public int getFriendship() {
        return this.pokemon.getFriendship();
    }

    @Override
    public boolean doesLevel() {
        return this.pokemon.doesLevel();
    }

    @Override
    public EntityPlayerMP getPlayerOwner() {
        return this.pokemon.getOwnerPlayer();
    }

    @Override
    public BattleControllerBase getBattleController() {
        PixelmonWrapper pw = this.pokemon.getPixelmonWrapperIfExists();
        return pw == null ? null : pw.bc;
    }

    @Override
    public Moveset getMoveset() {
        return this.pokemon.getMoveset();
    }

    @Override
    public UUID getPokemonUUID() {
        return this.pokemon.getUUID();
    }

    @Override
    public EntityPixelmon getEntity() {
        return this.pokemon.getOrSpawnPixelmon((Entity)(this.getPlayerOwner() == null ? null : this.getPlayerOwner()));
    }

    @Override
    public void setScale(float scale) {
        this.pokemon.ifEntityExists(pixelmon -> pixelmon.setPixelmonScale(scale));
    }

    @Override
    public World getWorld() {
        EntityPixelmon pixelmon = this.pokemon.getPixelmonIfExists();
        return pixelmon == null ? null : pixelmon.func_130014_f_();
    }

    @Override
    public Gender getGender() {
        return this.pokemon.getGender();
    }

    @Override
    public BlockPos getPos() {
        EntityPixelmon pixelmon = this.pokemon.getPixelmonIfExists();
        return pixelmon == null ? null : pixelmon.func_180425_c();
    }

    @Override
    public PartyStorage getStorage() {
        return (PartyStorage)this.pokemon.getStorageAndPosition().func_76341_a();
    }

    @Override
    public void update(EnumUpdateType ... updateTypes) {
        this.pokemon.markDirty(updateTypes);
    }

    @Override
    public void updateStats() {
        this.pokemon.getStats().setLevelStats(this.getNature(), this.getBaseStats(), this.getLevel());
        this.update(EnumUpdateType.Stats);
    }

    @Override
    public void updateLevelUp(PixelmonStatsData stats) {
        EntityPlayerMP owner = this.pokemon.getOwnerPlayer();
        if (owner != null) {
            PixelmonStatsData stats2 = PixelmonStatsData.createPacket(this);
            Pixelmon.network.sendTo((IMessage)new LevelUp(this.getPokemonUUID(), this.getLevel(), stats, stats2), owner);
            this.pokemon.markDirty(EnumUpdateType.Stats);
        }
    }

    @Override
    public void sendMessage(String langKey, Object ... data) {
        EntityPlayerMP player = this.pokemon.getOwnerPlayer();
        if (player != null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation(langKey, data));
        }
    }

    @Override
    public String getNickname() {
        return this.pokemon.getDisplayName();
    }

    @Override
    public String getOriginalTrainer() {
        return this.pokemon.getOriginalTrainer();
    }

    @Override
    public boolean removeStatuses(StatusType ... statuses) {
        for (StatusType statusType : statuses) {
            if (!statusType.isPrimaryStatus()) continue;
            this.pokemon.setStatus(NoStatus.noStatus);
            return true;
        }
        return false;
    }

    @Override
    public EnumNature getNature() {
        return this.pokemon.getNature();
    }

    @Override
    public int getExpToNextLevel() {
        return this.pokemon.getExperienceToLevelUp();
    }

    @Override
    public StatusPersist getPrimaryStatus() {
        return this.pokemon.getStatus();
    }

    @Override
    public AbilityBase getAbility() {
        return this.pokemon.getAbility();
    }

    @Override
    public List<EnumType> getType() {
        return this.getBaseStats().types;
    }

    @Override
    public int getForm() {
        return this.pokemon.getForm();
    }

    @Override
    public boolean isEgg() {
        return this.pokemon.isEgg();
    }

    @Override
    public int getEggCycles() {
        return this.pokemon.getEggCycles();
    }

    @Override
    public int getPartyPosition() {
        return ((StoragePosition)this.pokemon.getStorageAndPosition().func_76340_b()).order;
    }

    @Override
    public boolean hasOwner() {
        return this.pokemon.getStorageAndPosition().func_76341_a() != null;
    }

    @Override
    public Optional<Pokerus> getPokerus() {
        return Optional.ofNullable(this.pokemon.getPokerus());
    }

    @Override
    public void adjustFriendship(int change) {
        if (change > 0) {
            this.pokemon.increaseFriendship(change);
        } else {
            this.pokemon.decreaseFriendship(-change);
        }
    }
}

