/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.util.ITranslatable;

public enum EnumStatueTextureType implements ITranslatable
{
    OriginalTexture(0),
    Shiny(1),
    Special(2),
    Stone(3),
    Gold(4),
    Bronze(5),
    Silver(6),
    BossGreen(7, EnumBossMode.Uncommon),
    BossYellow(8, EnumBossMode.Rare),
    BossRed(9, EnumBossMode.Legendary),
    BossOrange(10, EnumBossMode.Ultimate);

    public int index;
    public EnumBossMode bossMode;

    private EnumStatueTextureType(int index) {
        this(index, EnumBossMode.NotBoss);
    }

    private EnumStatueTextureType(int index, EnumBossMode bossMode) {
        this.index = index;
        this.bossMode = bossMode;
    }

    public static EnumStatueTextureType getFromOrdinal(int value) {
        if (value >= EnumStatueTextureType.values().length) {
            return BossRed;
        }
        for (EnumStatueTextureType t : EnumStatueTextureType.values()) {
            if (t.ordinal() != value) continue;
            return t;
        }
        return null;
    }

    public EnumStatueTextureType getNextType(EnumStatueTextureType t) {
        int index = t.ordinal();
        index = index >= EnumStatueTextureType.values().length - 1 ? 0 : ++index;
        return EnumStatueTextureType.getFromOrdinal(index);
    }

    public static EnumStatueTextureType getFromString(String name) {
        for (EnumStatueTextureType t : EnumStatueTextureType.values()) {
            if (!t.toString().equalsIgnoreCase(name)) continue;
            return t;
        }
        return OriginalTexture;
    }

    @Override
    public String getUnlocalizedName() {
        return "enum.statuetex." + this.toString().toLowerCase();
    }
}

