/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;

public enum EnumTreasureRarity {
    COMMON(0.8f),
    UNCOMMON(0.6f),
    UNLIKELY(0.4f),
    SEMI_RARE(0.2f),
    RARE(0.1f),
    VERY_RARE(0.05f),
    SUPER_RARE(0.01f),
    ULTRA_RARE(0.005f),
    ALWAYS(1.0f),
    NEVER(0.0f);

    public static final EnumTreasureRarity[] STANDARD_RARITIES;
    public static final float[] midPoints;
    public final float chance;

    private EnumTreasureRarity(float chance) {
        this.chance = chance;
    }

    public static EnumTreasureRarity round(float chance) {
        for (int i = 0; i < midPoints.length; ++i) {
            if (!(chance >= midPoints[i])) continue;
            return EnumTreasureRarity.values()[i];
        }
        return ULTRA_RARE;
    }

    public static float estimateRarity(EnumPokeballs ballType) {
        switch (ballType) {
            case PokeBall: {
                return EnumTreasureRarity.COMMON.chance;
            }
            case GreatBall: {
                return EnumTreasureRarity.UNCOMMON.chance;
            }
            case UltraBall: {
                return EnumTreasureRarity.UNLIKELY.chance;
            }
            case MasterBall: {
                return EnumTreasureRarity.ULTRA_RARE.chance;
            }
            case PremierBall: {
                return COMMON.average(UNCOMMON);
            }
        }
        return EnumTreasureRarity.UNLIKELY.chance;
    }

    public float average(EnumTreasureRarity other) {
        return (this.chance + other.chance) / 2.0f;
    }

    public float average(float other) {
        return (this.chance + other) / 2.0f;
    }

    public static boolean hasTreasureRarity(String name) {
        try {
            return EnumTreasureRarity.valueOf(name) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        STANDARD_RARITIES = new EnumTreasureRarity[]{COMMON, UNCOMMON, UNLIKELY, SEMI_RARE, RARE, VERY_RARE, SUPER_RARE, ULTRA_RARE};
        midPoints = new float[]{UNCOMMON.average(COMMON), UNLIKELY.average(UNCOMMON), SEMI_RARE.average(UNLIKELY), RARE.average(SEMI_RARE), VERY_RARE.average(RARE), SUPER_RARE.average(VERY_RARE), ULTRA_RARE.average(SUPER_RARE)};
    }
}

