/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.util.List;

public enum EnumAlcremie implements IEnumForm
{
    STRAWBERRY(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.VANILLA),
    STRAWBERRYRUBYCREAM(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.RUBYCREAM),
    STRAWBERRYMATCHA(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.MATCHA),
    STRAWBERRYMINT(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.MINT),
    STRAWBERRYLEMON(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.LEMON),
    STRAWBERRYSALTED(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.SALTED),
    STRAWBERRYRUBYSWIRL(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.RUBYSWIRL),
    STRAWBERRYCARAMEL(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.CARAMEL),
    STRAWBERRYRAINBOW(EnumAlcremieModel.STRAWBERRY, EnumAlcremieTexture.RAINBOW),
    BERRY(EnumAlcremieModel.BERRY, EnumAlcremieTexture.VANILLA),
    BERRYRUBYCREAM(EnumAlcremieModel.BERRY, EnumAlcremieTexture.RUBYCREAM),
    BERRYMATCHA(EnumAlcremieModel.BERRY, EnumAlcremieTexture.MATCHA),
    BERRYMINT(EnumAlcremieModel.BERRY, EnumAlcremieTexture.MINT),
    BERRYLEMON(EnumAlcremieModel.BERRY, EnumAlcremieTexture.LEMON),
    BERRYSALTED(EnumAlcremieModel.BERRY, EnumAlcremieTexture.SALTED),
    BERRYRUBYSWIRL(EnumAlcremieModel.BERRY, EnumAlcremieTexture.RUBYSWIRL),
    BERRYCARAMEL(EnumAlcremieModel.BERRY, EnumAlcremieTexture.CARAMEL),
    BERRYRAINBOW(EnumAlcremieModel.BERRY, EnumAlcremieTexture.RAINBOW),
    LOVE(EnumAlcremieModel.LOVE, EnumAlcremieTexture.VANILLA),
    LOVERUBYCREAM(EnumAlcremieModel.LOVE, EnumAlcremieTexture.RUBYCREAM),
    LOVEMATCHA(EnumAlcremieModel.LOVE, EnumAlcremieTexture.MATCHA),
    LOVEMINT(EnumAlcremieModel.LOVE, EnumAlcremieTexture.MINT),
    LOVELEMON(EnumAlcremieModel.LOVE, EnumAlcremieTexture.LEMON),
    LOVESALTED(EnumAlcremieModel.LOVE, EnumAlcremieTexture.SALTED),
    LOVERUBYSWIRL(EnumAlcremieModel.LOVE, EnumAlcremieTexture.RUBYSWIRL),
    LOVECARAMEL(EnumAlcremieModel.LOVE, EnumAlcremieTexture.CARAMEL),
    LOVERAINBOW(EnumAlcremieModel.LOVE, EnumAlcremieTexture.RAINBOW),
    STAR(EnumAlcremieModel.STAR, EnumAlcremieTexture.VANILLA),
    STARRUBYCREAM(EnumAlcremieModel.STAR, EnumAlcremieTexture.RUBYCREAM),
    STARMATCHA(EnumAlcremieModel.STAR, EnumAlcremieTexture.MATCHA),
    STARMINT(EnumAlcremieModel.STAR, EnumAlcremieTexture.MINT),
    STARLEMON(EnumAlcremieModel.STAR, EnumAlcremieTexture.LEMON),
    STARSALTED(EnumAlcremieModel.STAR, EnumAlcremieTexture.SALTED),
    STARRUBYSWIRL(EnumAlcremieModel.STAR, EnumAlcremieTexture.RUBYSWIRL),
    STARCARAMEL(EnumAlcremieModel.STAR, EnumAlcremieTexture.CARAMEL),
    STARRAINBOW(EnumAlcremieModel.STAR, EnumAlcremieTexture.RAINBOW),
    CLOVER(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.VANILLA),
    CLOVERRUBYCREAM(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.RUBYCREAM),
    CLOVERMATCHA(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.MATCHA),
    CLOVERMINT(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.MINT),
    CLOVERLEMON(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.LEMON),
    CLOVERSALTED(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.SALTED),
    CLOVERRUBYSWIRL(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.RUBYSWIRL),
    CLOVERCARAMEL(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.CARAMEL),
    CLOVERRAINBOW(EnumAlcremieModel.CLOVER, EnumAlcremieTexture.RAINBOW),
    FLOWER(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.VANILLA),
    FLOWERRUBYCREAM(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.RUBYCREAM),
    FLOWERMATCHA(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.MATCHA),
    FLOWERMINT(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.MINT),
    FLOWERLEMON(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.LEMON),
    FLOWERSALTED(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.SALTED),
    FLOWERRUBYSWIRL(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.RUBYSWIRL),
    FLOWERCARAMEL(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.CARAMEL),
    FLOWERRAINBOW(EnumAlcremieModel.FLOWER, EnumAlcremieTexture.RAINBOW),
    RIBBON(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.VANILLA),
    RIBBONRUBYCREAM(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.RUBYCREAM),
    RIBBONMATCHA(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.MATCHA),
    RIBBONMINT(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.MINT),
    RIBBONLEMON(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.LEMON),
    RIBBONSALTED(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.SALTED),
    RIBBONRUBYSWIRL(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.RUBYSWIRL),
    RIBBONCARAMEL(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.CARAMEL),
    RIBBONRAINBOW(EnumAlcremieModel.RIBBON, EnumAlcremieTexture.RAINBOW);

    private static final List<EnumAlcremie> strawberryList;
    private static final List<EnumAlcremie> berryList;
    private static final List<EnumAlcremie> loveList;
    private static final List<EnumAlcremie> starList;
    private static final List<EnumAlcremie> cloverList;
    private static final List<EnumAlcremie> flowerList;
    private static final List<EnumAlcremie> ribbonList;
    private final EnumAlcremieModel model;
    private final EnumAlcremieTexture texture;

    public static List<EnumAlcremie> getStrawberryList() {
        return ImmutableList.copyOf(strawberryList);
    }

    public static List<EnumAlcremie> getBerryList() {
        return ImmutableList.copyOf(berryList);
    }

    public static List<EnumAlcremie> getLoveList() {
        return ImmutableList.copyOf(loveList);
    }

    public static List<EnumAlcremie> getStarList() {
        return ImmutableList.copyOf(starList);
    }

    public static List<EnumAlcremie> getCloverList() {
        return ImmutableList.copyOf(cloverList);
    }

    public static List<EnumAlcremie> getFlowerList() {
        return ImmutableList.copyOf(flowerList);
    }

    public static List<EnumAlcremie> getRibbonList() {
        return ImmutableList.copyOf(ribbonList);
    }

    private EnumAlcremie(EnumAlcremieModel model, EnumAlcremieTexture texture) {
        this.model = model;
        this.texture = texture;
    }

    private String getBase_(boolean isShiny) {
        return isShiny ? "shinyalcremie" : "alcremie";
    }

    private String getModel_(boolean isShiny) {
        switch (this.model) {
            case BERRY: {
                return "-berry";
            }
            case CLOVER: {
                return "-clover";
            }
            case FLOWER: {
                return "-flower";
            }
            case LOVE: {
                return "-love";
            }
            case RIBBON: {
                return "-ribbon";
            }
            case STAR: {
                return "-star";
            }
            case STRAWBERRY: {
                return "-strawberry";
            }
        }
        return "-berry";
    }

    private String getTexture_(boolean isShiny) {
        if (isShiny) {
            return "";
        }
        switch (this.texture) {
            case CARAMEL: {
                return "-caramel";
            }
            case LEMON: {
                return "-lemon";
            }
            case MATCHA: {
                return "-matcha";
            }
            case MINT: {
                return "-mint";
            }
            case RAINBOW: {
                return "-rainbow";
            }
            case RUBYCREAM: {
                return "-rubycream";
            }
            case RUBYSWIRL: {
                return "-rubyswirl";
            }
            case SALTED: {
                return "-salted";
            }
            case VANILLA: {
                return "-vanilla";
            }
        }
        return "-caramel";
    }

    public String getTexture() {
        return this.getBase_(false) + this.getModel_(false) + this.getTexture_(false) + ".png";
    }

    public String getTexture(boolean isShiny) {
        return this.getBase_(isShiny) + this.getModel_(isShiny) + this.getTexture_(isShiny) + ".png";
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.alcremie.form." + this.name().toLowerCase();
    }

    @Override
    public String getFormSuffix() {
        return this.getModel_(false) + this.getTexture_(false);
    }

    @Override
    public String getFormSuffix(boolean isShiny) {
        return this.getModel_(isShiny) + this.getTexture_(isShiny);
    }

    static {
        strawberryList = Lists.newArrayList((Object[])new EnumAlcremie[]{STRAWBERRY, STRAWBERRYRUBYCREAM, STRAWBERRYMATCHA, STRAWBERRYMINT, STRAWBERRYLEMON, STRAWBERRYSALTED, STRAWBERRYRUBYSWIRL, STRAWBERRYCARAMEL, STRAWBERRYRAINBOW});
        berryList = Lists.newArrayList((Object[])new EnumAlcremie[]{BERRY, BERRYRUBYCREAM, BERRYMATCHA, BERRYMINT, BERRYLEMON, BERRYSALTED, BERRYRUBYSWIRL, BERRYCARAMEL, BERRYRAINBOW});
        loveList = Lists.newArrayList((Object[])new EnumAlcremie[]{LOVE, LOVERUBYCREAM, LOVEMATCHA, LOVEMINT, LOVELEMON, LOVESALTED, LOVERUBYSWIRL, LOVECARAMEL, LOVERAINBOW});
        starList = Lists.newArrayList((Object[])new EnumAlcremie[]{STAR, STARRUBYCREAM, STARMATCHA, STARMINT, STARLEMON, STARSALTED, STARRUBYSWIRL, STARCARAMEL, STARRAINBOW});
        cloverList = Lists.newArrayList((Object[])new EnumAlcremie[]{CLOVER, CLOVERRUBYCREAM, CLOVERMATCHA, CLOVERMINT, CLOVERLEMON, CLOVERSALTED, CLOVERRUBYSWIRL, CLOVERCARAMEL, CLOVERRAINBOW});
        flowerList = Lists.newArrayList((Object[])new EnumAlcremie[]{FLOWER, FLOWERRUBYCREAM, FLOWERMATCHA, FLOWERMINT, FLOWERLEMON, FLOWERSALTED, FLOWERRUBYSWIRL, FLOWERCARAMEL, FLOWERRAINBOW});
        ribbonList = Lists.newArrayList((Object[])new EnumAlcremie[]{RIBBON, RIBBONRUBYCREAM, RIBBONMATCHA, RIBBONMINT, RIBBONLEMON, RIBBONSALTED, RIBBONRUBYSWIRL, RIBBONCARAMEL, RIBBONRAINBOW});
    }

    public static enum EnumAlcremieTexture {
        VANILLA,
        RUBYCREAM,
        MATCHA,
        MINT,
        LEMON,
        SALTED,
        RUBYSWIRL,
        CARAMEL,
        RAINBOW;

    }

    public static enum EnumAlcremieModel {
        STRAWBERRY,
        BERRY,
        LOVE,
        STAR,
        CLOVER,
        FLOWER,
        RIBBON;

    }
}

