/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EntityPlayerExtension {
    public static DataParameter<String> dwPokeballs = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187194_d);
    public static DataParameter<Byte> dwMegaItem = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187191_a);
    public static DataParameter<Byte> dwMegaItemsUnlocked = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187191_a);
    public static DataParameter<Byte> dwShinyCharm = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187191_a);
    public static DataParameter<Byte> dwOvalCharm = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187191_a);
    public static DataParameter<Byte> dwHween = EntityDataManager.func_187226_a(EntityPlayer.class, (DataSerializer)DataSerializers.field_187191_a);

    @SubscribeEvent
    public static void handleConstruction(EntityEvent.EntityConstructing event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityDataManager dw = event.getEntity().func_184212_Q();
            dw.func_187214_a(dwPokeballs, (Object)"-1,-1,-1,-1,-1,-1,");
            dw.func_187214_a(dwMegaItem, (Object)0);
            dw.func_187214_a(dwMegaItemsUnlocked, (Object)0);
            dw.func_187214_a(dwShinyCharm, (Object)0);
            dw.func_187214_a(dwOvalCharm, (Object)0);
            dw.func_187214_a(dwHween, (Object)0);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerExtension.resendAll((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerExtension.resendAll((EntityPlayerMP)event.player);
        }
    }

    private static void resendAll(EntityPlayerMP player) {
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
        if (party != null) {
            EntityPlayerExtension.updatePlayerPokeballs(player, party.getAll());
            EntityPlayerExtension.updatePlayerMegaItem(player, party.getMegaItem());
            EntityPlayerExtension.updatePlayerMegaItemsUnlocked(player, party.getMegaItemsUnlocked());
            EntityPlayerExtension.updatePlayerOvalCharm(player, party.getOvalCharm());
            EntityPlayerExtension.updatePlayerShinyCharm(player, party.getShinyCharm());
            EntityPlayerExtension.updatePlayerHweenRobe(player, party.getHweenRobe());
        }
    }

    public static void updatePlayerPokeballs(EntityPlayerMP player, Pokemon[] pokemon) {
        if (player == null) {
            return;
        }
        StringBuilder ballsList = new StringBuilder();
        for (int i = 0; i < pokemon.length; ++i) {
            if (pokemon[i] != null && !pokemon[i].isEgg()) {
                ballsList.append(pokemon[i].getCaughtBall().getIndex()).append(",");
                continue;
            }
            ballsList.append("-1").append(",");
        }
        player.func_184212_Q().func_187227_b(dwPokeballs, (Object)ballsList.toString());
    }

    public static int[] getPlayerPokeballs(EntityPlayer player) {
        String ballsList = (String)player.func_184212_Q().func_187225_a(dwPokeballs);
        String[] splits = ballsList.split(",");
        int[] balls = new int[6];
        for (int i = 0; i < 6; ++i) {
            balls[i] = Integer.parseInt(splits[i]);
        }
        return balls;
    }

    public static void updatePlayerMegaItem(EntityPlayerMP player, EnumMegaItem megaItem) {
        player.func_184212_Q().func_187227_b(dwMegaItem, (Object)((byte)megaItem.ordinal()));
    }

    public static EnumMegaItem getPlayerMegaItem(EntityPlayer player) {
        return EnumMegaItem.fromOrdinal(((Byte)player.func_184212_Q().func_187225_a(dwMegaItem)).byteValue());
    }

    public static void updatePlayerMegaItemsUnlocked(EntityPlayerMP player, EnumMegaItemsUnlocked megaItemsUnlocked) {
        player.func_184212_Q().func_187227_b(dwMegaItemsUnlocked, (Object)((byte)megaItemsUnlocked.ordinal()));
    }

    public static EnumMegaItemsUnlocked getPlayerMegaItemsUnlocked(EntityPlayer player) {
        return EnumMegaItemsUnlocked.fromOrdinal(((Byte)player.func_184212_Q().func_187225_a(dwMegaItemsUnlocked)).byteValue());
    }

    public static void updatePlayerShinyCharm(EntityPlayerMP player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwShinyCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerShinyCharm(EntityPlayer player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwShinyCharm)];
    }

    public static void updatePlayerOvalCharm(EntityPlayerMP player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwOvalCharm, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerOvalCharm(EntityPlayer player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwOvalCharm)];
    }

    public static void updatePlayerHweenRobe(EntityPlayerMP player, EnumFeatureState charm) {
        player.func_184212_Q().func_187227_b(dwHween, (Object)((byte)charm.ordinal()));
    }

    public static EnumFeatureState getPlayerHweenRobe(EntityPlayer player) {
        return EnumFeatureState.values()[(Byte)player.func_184212_Q().func_187225_a(dwHween)];
    }

    static {
        Pixelmon.LOGGER.warn("Ignore the above warning messages ^ This is intended and working fine.");
    }
}

