/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectionList;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ServerConfigList;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.UpdateClientRules;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.UpdateClientPlayerData;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.customStarters.SelectPokemonController;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DropItemQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.MoveCostList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PixelmonPlayerTracker {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        Pixelmon.network.sendTo((IMessage)new ServerConfigList(), player);
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
        party.pokedex.checkForShinyCharm();
        for (int i = 0; i < 6; ++i) {
            party.notifyListeners(new StoragePosition(-1, i), party.get(i), EnumUpdateType.CLIENT);
        }
        PixelmonPlayerTracker.removePlayer(player);
        if (PixelmonConfig.alwaysHaveMegaRing) {
            try {
                if (!party.getMegaItemsUnlocked().canMega()) {
                    party.setMegaItem(EnumMegaItem.BraceletORAS, false);
                    party.unlockMega();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (PixelmonConfig.alwaysHaveDynamaxBand) {
            try {
                if (!party.getMegaItemsUnlocked().canDynamax()) {
                    party.setMegaItem(EnumMegaItem.DynamaxBand, false);
                    party.unlockDynamax();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Pixelmon.moneyManager.getBankAccount(player).get().updatePlayer();
        Pixelmon.network.sendTo((IMessage)new UpdateClientPlayerData(party.trainerCardColor), player);
        party.pokedex.update();
        Pixelmon.network.sendTo((IMessage)new UpdateClientRules(), player);
        PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (player instanceof EntityPlayerMP) {
            PixelmonPlayerTracker.removePlayer((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        Entity eventEntity = event.getEntity();
        if (event.getEntity() instanceof EntityPlayerMP) {
            PixelmonPlayerTracker.removePlayer((EntityPlayerMP)eventEntity);
        }
    }

    public static void removePlayer(EntityPlayerMP player) {
        try {
            EvolutionQuery eq;
            Pixelmon.storageManager.getParty(player).retrieveAll();
            SelectPokemonController.removePlayer(player);
            BattleQuery bq = BattleQuery.getQuery(player);
            if (bq != null) {
                bq.declineQuery(player);
            }
            if ((eq = EvolutionQueryList.get((EntityPlayer)player)) != null) {
                EvolutionQueryList.declineQuery(player, eq.pokemonUUID);
            }
            DropItemQueryList.removeQuery(player);
            BattleControllerBase bc = BattleRegistry.getBattle((EntityPlayer)player);
            if (bc != null) {
                if (bc.hasSpectator((EntityPlayer)player)) {
                    bc.removeSpectator(player);
                } else {
                    bc.endBattle(EnumBattleEndCause.FORCE);
                }
            }
            MoveCostList.removeEntry(player);
            TeamSelectionList.removeSelection(player);
            NPCTrades.clearTradePair(player.func_110124_au());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

