/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.PokerusEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackAction;
import com.pixelmonmod.pixelmon.battles.controller.log.BattleActionBase;
import com.pixelmonmod.pixelmon.battles.controller.log.MoveResults;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Pokerus;
import com.pixelmonmod.pixelmon.enums.EnumPokerusType;
import com.pixelmonmod.pixelmon.enums.battle.BattleResults;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PokerusSpreader {
    private static Random rnd = new Random();

    @SubscribeEvent
    public static void onBattleEnd(BattleEndEvent event) {
        if (!PixelmonConfig.pokerusEnabled || PixelmonConfig.pokerusSpreadRate < 0) {
            return;
        }
        if (!event.abnormal) {
            ArrayList winners = new ArrayList();
            event.results.forEach((participant, result) -> {
                if (result == BattleResults.VICTORY && participant instanceof PlayerParticipant) {
                    PokerusSpreader.spreadToParty((PlayerParticipant)participant);
                    winners.add(((PlayerParticipant)participant).player.func_110124_au());
                }
            });
            if (!winners.isEmpty()) {
                HashMap<UUID, List> analyzedMap = new HashMap<UUID, List>();
                for (BattleActionBase[] un1 : event.bc.battleLog.getLog()) {
                    for (BattleActionBase un2 : un1) {
                        if (!(un2 instanceof AttackAction)) continue;
                        AttackAction attack = (AttackAction)un2;
                        if (attack.pokemon.getPokerus().isPresent() || !(attack.pokemon.getParticipant() instanceof PlayerParticipant) || !winners.contains(((PlayerParticipant)attack.pokemon.getParticipant()).player.func_110124_au())) continue;
                        UUID receiver = attack.pokemon.getPokemonUUID();
                        if (!analyzedMap.containsKey(receiver)) {
                            analyzedMap.put(receiver, new ArrayList());
                        }
                        for (MoveResults res : attack.moveResults) {
                            if (res == null || res.target == null || !res.target.getPokerus().isPresent() || !res.result.isSuccess()) continue;
                            UUID donor = res.target.getPokemonUUID();
                            List donors = (List)analyzedMap.get(receiver);
                            if (donors.contains(donor)) continue;
                            donors.add(donor);
                            analyzedMap.put(receiver, donors);
                            res.target.getPokerus().ifPresent(pkrs -> PokerusSpreader.spread(pkrs.type, attack.pokemon, (PlayerPartyStorage)attack.pokemon.getParticipant().getStorage()));
                        }
                    }
                }
            }
        }
    }

    private static void spreadToParty(PlayerParticipant participant) {
        PixelmonWrapper[] party = participant.allPokemon;
        for (int i = 0; i < party.length; ++i) {
            Pokerus pkrs;
            if (!party[i].isAlive() && !party[i].pokemon.isEgg() || (pkrs = (Pokerus)party[i].getPokerus().orElse(null)) == null) continue;
            if (i > 0) {
                PokerusSpreader.spread(pkrs.type, party[i - 1], participant.getStorage());
            }
            if (i + 1 >= party.length) continue;
            PokerusSpreader.spread(pkrs.type, party[i + 1], participant.getStorage());
        }
    }

    private static void spread(EnumPokerusType donorType, PixelmonWrapper wrapper, PlayerPartyStorage storage) {
        if (wrapper.isFainted()) {
            return;
        }
        if (!(PixelmonConfig.pokerusSpreadRate != 0 && rnd.nextInt(PixelmonConfig.pokerusSpreadRate) != 0 || Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Spread.Pre(storage, wrapper, donorType)))) {
            if (wrapper.entity == null) {
                Pokemon pokemon = wrapper.pokemon;
                Pokerus pokerus = new Pokerus(donorType);
                pokemon.setPokerus(pokerus);
            } else {
                EntityPixelmon receiver = wrapper.entity;
                receiver.getPokemonData().setPokerus(new Pokerus(donorType));
                receiver.update(EnumUpdateType.Pokerus);
            }
            Pixelmon.EVENT_BUS.post((Event)new PokerusEvent.Spread.Post(storage, wrapper, donorType));
        }
    }
}

