/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener.spawn;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockMCMobSpawn {
    @SubscribeEvent
    public static void checkSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (BlockMCMobSpawn.isDisabledEntity((Entity)event.getEntityLiving(), event.getWorld())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void checkEntitySpawn(EntityJoinWorldEvent event) {
        if (BlockMCMobSpawn.isDisabledEntity(event.getEntity(), event.getWorld())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void blockEntitiesSpawn(PopulateChunkEvent.Populate event) {
        if (event.getType() == PopulateChunkEvent.Populate.EventType.ANIMALS && !PixelmonConfig.allowNonPixelmonMobs) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isDisabledEntity(Entity entity, World world) {
        if (!PixelmonConfig.allowNonPixelmonMobs && !world.field_72995_K) {
            EntityHorse horse;
            if (entity instanceof EntityGuardian || entity instanceof EntityCaveSpider || entity instanceof EntitySilverfish || entity instanceof EntityBlaze || entity instanceof EntityWitch) {
                return true;
            }
            if (entity instanceof EntityHorse && (horse = (EntityHorse)entity).func_70662_br()) {
                return true;
            }
        }
        return false;
    }
}

