/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.enums.EnumPlate;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GiveItemAction
implements IAction {
    @Override
    public String identifier() {
        return "ITEM_GIVE";
    }

    @Override
    public Object[] parse(Quest quest, Stage stage, String ... args) {
        Item item = Items.field_190931_a;
        int amount = 1;
        int meta = 0;
        block11: for (String arg : args) {
            if (!arg.contains("=")) continue;
            String[] split = arg.split("=");
            switch (split[0].toLowerCase()) {
                case "item": {
                    if (split[1].startsWith("special:")) {
                        return new Object[]{split[1].split(":")[1]};
                    }
                    item = Item.func_111206_d((String)split[1]);
                    continue block11;
                }
                case "amount": 
                case "count": {
                    amount = Integer.parseInt(split[1]);
                    continue block11;
                }
                case "meta": {
                    meta = Integer.parseInt(split[1]);
                }
            }
        }
        ItemStack stack = new ItemStack(item, amount, meta);
        return new Object[]{stack};
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Object ... args) {
        if (args[0] instanceof ItemStack) {
            ItemStack stack = (ItemStack)args[0];
            data.getPlayer().func_191521_c(stack.func_77946_l());
        } else {
            Item item;
            String[] split = ((String)args[0]).split(",");
            String special = split[0];
            int amount = Integer.parseInt(split[1]);
            if (special.equalsIgnoreCase("BerryTypeReducing")) {
                Item item2 = this.getBerryTypeReducing(EnumType.parseType(progress.getDataString("POKEMON10T")));
                if (item2 != null) {
                    ItemStack stack = new ItemStack(item2, amount);
                    data.getPlayer().func_191521_c(stack);
                }
            } else if (special.equalsIgnoreCase("Plate") && (item = this.getPlate(EnumType.parseType(progress.getDataString("POKEMON10T")))) != null) {
                ItemStack stack = new ItemStack(item, amount);
                data.getPlayer().func_191521_c(stack);
            }
        }
    }

    private Item getBerryTypeReducing(EnumType type) {
        switch (type) {
            case Bug: {
                return PixelmonItemsHeld.tangaBerry;
            }
            case Ice: {
                return PixelmonItemsHeld.yacheBerry;
            }
            case Fire: {
                return PixelmonItemsHeld.occaBerry;
            }
            case Water: {
                return PixelmonItemsHeld.passhoBerry;
            }
            case Electric: {
                return PixelmonItemsHeld.wacanBerry;
            }
            case Grass: {
                return PixelmonItemsHeld.rindoBerry;
            }
            case Fighting: {
                return PixelmonItemsHeld.chopleBerry;
            }
            case Poison: {
                return PixelmonItemsHeld.kebiaBerry;
            }
            case Ground: {
                return PixelmonItemsHeld.shucaBerry;
            }
            case Flying: {
                return PixelmonItemsHeld.cobaBerry;
            }
            case Psychic: {
                return PixelmonItemsHeld.payapaBerry;
            }
            case Rock: {
                return PixelmonItemsHeld.chartiBerry;
            }
            case Ghost: {
                return PixelmonItemsHeld.kasibBerry;
            }
            case Dragon: {
                return PixelmonItemsHeld.habanBerry;
            }
            case Dark: {
                return PixelmonItemsHeld.colburBerry;
            }
            case Steel: {
                return PixelmonItemsHeld.babiriBerry;
            }
            case Normal: {
                return PixelmonItemsHeld.chilanBerry;
            }
            case Fairy: {
                return PixelmonItemsHeld.roseliBerry;
            }
        }
        return null;
    }

    private Item getPlate(EnumType type) {
        return type == EnumType.Normal ? PixelmonItemsHeld.lifeOrb : EnumPlate.getItem(type);
    }
}

