/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.actions.actions;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.actions.IAction;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import net.minecraft.entity.player.EntityPlayerMP;

public class KeyItemAction
implements IAction {
    private final boolean isTake;

    public KeyItemAction(boolean isTake) {
        this.isTake = isTake;
    }

    @Override
    public String identifier() {
        return this.isTake ? "TAKE_KEY_ITEM" : "KEY_ITEM";
    }

    @Override
    public Object[] parse(Quest quest, Stage stage, String ... args) throws InvalidQuestArgsException {
        KeyItem item;
        if (args.length == 3 && (item = KeyItem.getKeyItem(args[2])) != null) {
            return new Object[]{item};
        }
        throw new InvalidQuestArgsException("Invalid KEY_ITEM action in quest " + quest.getFilename() + "!");
    }

    @Override
    public void execute(Quest quest, Stage stage, QuestData data, QuestProgress progress, Object ... args) {
        KeyItem item = (KeyItem)((Object)args[0]);
        item.action(data.getPlayer(), this.isTake);
    }

    static enum KeyItem {
        MegaRing,
        DynamaxBand,
        OvalCharm,
        ShinyCharm;


        public static KeyItem getKeyItem(String name) {
            for (KeyItem item : KeyItem.values()) {
                if (!item.name().equalsIgnoreCase(name)) continue;
                return item;
            }
            return null;
        }

        public void action(EntityPlayerMP player, boolean isTake) {
            PlayerPartyStorage pps = Pixelmon.storageManager.getParty(player);
            switch (this) {
                case MegaRing: {
                    if (isTake) {
                        pps.lockMega();
                        break;
                    }
                    pps.unlockMega();
                    break;
                }
                case DynamaxBand: {
                    if (isTake) {
                        pps.lockDynamax();
                        break;
                    }
                    pps.unlockDynamax();
                    break;
                }
                case OvalCharm: {
                    if (isTake) {
                        pps.setOvalCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setOvalCharm(EnumFeatureState.Active);
                    break;
                }
                case ShinyCharm: {
                    if (isTake) {
                        pps.setShinyCharm(EnumFeatureState.Disabled);
                        break;
                    }
                    pps.setShinyCharm(EnumFeatureState.Active);
                }
            }
        }
    }
}

