/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.client.rendering;

import com.pixelmonmod.pixelmon.quests.client.QuestDataClient;
import com.pixelmonmod.pixelmon.quests.client.QuestProgressClient;
import com.pixelmonmod.pixelmon.quests.client.rendering.QuestResources;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.quest.QuestColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class QuestMarkerRenderer {
    @SubscribeEvent
    public void onRenderEvent(RenderWorldLastEvent event) {
        for (QuestProgressClient progress : QuestDataClient.getInstance().getQuests()) {
            for (QuestMarker marker : progress.getMarkers()) {
                Minecraft mc = Minecraft.func_71410_x();
                double x = marker.x;
                double y = marker.y;
                double z = marker.z;
                boolean found = false;
                if (marker.uuid != null) {
                    for (Entity entity : mc.field_71441_e.field_72996_f) {
                        if (entity == null || !entity.getPersistentID().equals(marker.uuid)) continue;
                        x = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)mc.func_184121_ak());
                        y = (double)((float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)mc.func_184121_ak()) + entity.func_70047_e()) + 0.8;
                        z = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)mc.func_184121_ak());
                        found = true;
                        break;
                    }
                } else {
                    found = true;
                }
                if (!found) continue;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                GlStateManager.func_179112_b((int)770, (int)771);
                EntityPlayerSP viewpoint = mc.func_175606_aa() == null ? mc.field_71439_g : mc.func_175606_aa();
                float tx = (float)(viewpoint.field_70169_q + (viewpoint.field_70165_t - viewpoint.field_70169_q) * (double)mc.func_184121_ak());
                float ty = (float)(viewpoint.field_70167_r + (viewpoint.field_70163_u - viewpoint.field_70167_r) * (double)mc.func_184121_ak());
                float tz = (float)(viewpoint.field_70166_s + (viewpoint.field_70161_v - viewpoint.field_70166_s) * (double)mc.func_184121_ak());
                GlStateManager.func_179109_b((float)(-tx), (float)(-ty), (float)(-tz));
                mc.field_71446_o.func_110577_a(QuestResources.getMarkerTexture(progress, marker));
                QuestColor qc = marker.color;
                GlStateManager.func_179131_c((float)qc.floatR(), (float)qc.floatG(), (float)qc.floatB(), (float)1.0f);
                GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                float angle = (float)(Math.atan2(z - (double)tz, x - (double)tx) * 180.0 / Math.PI) + 90.0f;
                GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.075, (double)0.075, (double)0.075);
                QuestResources.getMarkerModel(marker).render();
                GlStateManager.func_179084_k();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        QuestDataClient.getInstance().clear();
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        QuestDataClient.getInstance().clear();
    }
}

