/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.quests.objectives.objectives.entity;

import com.pixelmonmod.pixelmon.api.dialogue.Choice;
import com.pixelmonmod.pixelmon.api.dialogue.Dialogue;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.comm.QuestMarker;
import com.pixelmonmod.pixelmon.quests.exceptions.InvalidQuestArgsException;
import com.pixelmonmod.pixelmon.quests.objectives.IObjective;
import com.pixelmonmod.pixelmon.quests.objectives.Objective;
import com.pixelmonmod.pixelmon.quests.objectives.inserters.Inserter;
import com.pixelmonmod.pixelmon.quests.quest.Quest;
import com.pixelmonmod.pixelmon.quests.quest.Stage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.Entity;

public class DialogueInjectObjective
implements IObjective {
    private static final String DATA_TAG = "NPC";

    @Override
    public short quantity(Object[] objectiveArgsIn) {
        return 1;
    }

    @Override
    public String identifier() {
        return "DIALOGUE";
    }

    @Override
    public Inserter inserter() {
        return Inserter.ENTITY;
    }

    @Override
    public Object[] parse(Quest questIn, Stage stageIn, String ... argsIn) throws InvalidQuestArgsException {
        Dialogue.DialogueBuilder builder = Dialogue.builder();
        int choiceID = 0;
        for (int i = 2; i < argsIn.length; ++i) {
            String arg = argsIn[i];
            String[] kv = arg.split("=");
            if (kv[0].equalsIgnoreCase("name")) {
                builder.setName(questIn.getUnlocalizedString(kv[1]));
                continue;
            }
            if (kv[0].equalsIgnoreCase("text")) {
                builder.setText(questIn.getUnlocalizedString(kv[1]));
                continue;
            }
            if (!kv[0].equalsIgnoreCase("choice")) continue;
            builder.addChoice(Choice.builder().setText(questIn.getUnlocalizedString(kv[1])).build(choiceID++));
        }
        return new Object[]{argsIn[1], builder};
    }

    @Override
    public boolean test(Stage stageIn, QuestData dataIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) throws InvalidQuestArgsException {
        UUID uuid;
        Entity npc = (Entity)argsIn[0];
        if (npc != null && (uuid = this.getUUID(objectiveArgsIn, progressIn, stageIn)) != null && npc.getPersistentID().equals(uuid)) {
            if (npc instanceof NPCQuestGiver && argsIn.length > 1 && argsIn[1] != null) {
                NPCChatEvent event2 = (NPCChatEvent)((Object)argsIn[1]);
                event2.setCanceled(true);
            }
            Dialogue.DialogueBuilder builder = (Dialogue.DialogueBuilder)objectiveArgsIn[1];
            builder.injectHandler(event -> {
                try {
                    dataIn.receiveMultipleInternal(new String[]{"NPC_RESPOND", "NPC_TALK", "NPC_SHOW", "NPC_GIVE"}, new Object[][]{{npc, event.choice.choiceID}, {npc}, {npc, dataIn.getPlayer().func_184614_ca()}, {npc, dataIn.getPlayer().func_184614_ca()}}, true);
                }
                catch (InvalidQuestArgsException e) {
                    e.printStackTrace();
                }
            });
            builder.build().open(true, dataIn.getPlayer());
        }
        return false;
    }

    @Override
    public ArrayList<QuestMarker> mark(Stage stageIn, QuestProgress progressIn, Objective objectiveIn, Object[] objectiveArgsIn, Object ... argsIn) {
        return new ArrayList<QuestMarker>();
    }

    public UUID getUUID(Object[] objectiveArgsIn, QuestProgress progressIn, Stage stageIn) {
        String key = DATA_TAG + stageIn.getStage();
        String arg = (String)objectiveArgsIn[0];
        UUID uuidIn = null;
        if (arg.contains("-")) {
            uuidIn = UUID.fromString(arg);
        }
        if (!arg.startsWith("#!") && !arg.equalsIgnoreCase("*")) {
            key = arg;
        }
        if (uuidIn == null) {
            String data = progressIn.getDataString(key);
            if (data == null) {
                return null;
            }
            uuidIn = UUID.fromString(data);
        }
        return uuidIn;
    }
}

