/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.blocks.BlockBerryTree;
import com.pixelmonmod.pixelmon.blocks.GenericRotatableModelBlock;
import com.pixelmonmod.pixelmon.blocks.apricornTrees.BlockApricornTree;
import com.pixelmonmod.pixelmon.blocks.enums.EnumBlockPos;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityApricornTree;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityBerryTree;
import com.pixelmonmod.pixelmon.config.PixelmonBlocksApricornTrees;
import com.pixelmonmod.pixelmon.enums.EnumBerry;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.worldGeneration.structure.GeneratorHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenPixelmonTrees
implements IWorldGenerator {
    private Block[] apricorns = new Block[]{PixelmonBlocksApricornTrees.apricornTreeBlack, PixelmonBlocksApricornTrees.apricornTreeWhite, PixelmonBlocksApricornTrees.apricornTreePink, PixelmonBlocksApricornTrees.apricornTreeGreen, PixelmonBlocksApricornTrees.apricornTreeBlue, PixelmonBlocksApricornTrees.apricornTreeYellow, PixelmonBlocksApricornTrees.apricornTreeRed};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!world.field_73011_w.func_76569_d() && !GeneratorHelper.isUltraSpace(world)) {
            return;
        }
        Biome biome = world.func_180494_b(new BlockPos(chunkX * 16, 0, chunkZ * 16));
        if (BiomeDictionary.getTypes((Biome)biome).contains(BiomeDictionary.Type.FOREST)) {
            int count = random.nextInt(4);
            for (int i = 0; i < count - 1; ++i) {
                int z;
                int y;
                int x = random.nextInt(16) + chunkX * 16;
                Material material = world.func_180495_p(new BlockPos(x, (y = world.func_175645_m(new BlockPos(x, 0, z = random.nextInt(16) + chunkZ * 16)).func_177956_o()) - 1, z)).func_185904_a();
                if (material != Material.field_151577_b && material != Material.field_151578_c) continue;
                if (random.nextBoolean()) {
                    this.generateApricorn(x, y, z, world);
                    continue;
                }
                this.generateBerry(x, y, z, world);
            }
        }
    }

    public void generateApricorn(int x, int y, int z, World world) {
        TileEntityApricornTree tree;
        Block newBlock = RandomHelper.getRandomElementFromArray(this.apricorns);
        if (newBlock != null) {
            world.func_180501_a(new BlockPos(x, y, z), newBlock.func_176223_P().func_177226_a(BlockApricornTree.BLOCKPOS, (Comparable)((Object)EnumBlockPos.BOTTOM)), 18);
            world.func_180501_a(new BlockPos(x, y + 1, z), newBlock.func_176223_P().func_177226_a(BlockApricornTree.BLOCKPOS, (Comparable)((Object)EnumBlockPos.TOP)), 18);
        }
        if ((tree = BlockHelper.getTileEntity(TileEntityApricornTree.class, (IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            tree.setGenerated();
        }
    }

    public void generateBerry(int x, int y, int z, World world) {
        TileEntityBerryTree tree;
        EnumBerry berry = EnumBerry.getImplementedBerry();
        Block newBlock = berry.getTreeBlock();
        if (newBlock != null) {
            EnumFacing facing = RandomHelper.getRandomElementFromArray(EnumFacing.field_176754_o);
            world.func_180501_a(new BlockPos(x, y, z), newBlock.func_176223_P().func_177226_a(BlockBerryTree.BLOCKPOS, (Comparable)((Object)EnumBlockPos.BOTTOM)).func_177226_a((IProperty)GenericRotatableModelBlock.FACING, (Comparable)facing), 18);
        }
        if ((tree = BlockHelper.getTileEntity(TileEntityBerryTree.class, (IBlockAccess)world, new BlockPos(x, y, z))) != null) {
            tree.setGenerated();
        }
    }
}

