/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BlockFluidClassic
extends BlockFluidBase {
    protected static final List<fa> SIDES = Collections.unmodifiableList(Arrays.asList(fa.e, fa.f, fa.c, fa.d));
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected boolean canCreateSources = false;
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, bcz material, bda mapColor) {
        super(fluid, material, mapColor);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic(Fluid fluid, bcz material) {
        this(fluid, material, material.r());
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(amy world, et pos) {
        awt state = world.o(pos);
        if (state.u().isAir(state, world, pos)) {
            return 0;
        }
        if (state.u() != this) {
            return -1;
        }
        return this.quantaPerBlock - (Integer)state.c((axj)LEVEL);
    }

    @Override
    public boolean a(@Nonnull awt state, boolean fullHit) {
        return fullHit && (Integer)state.c((axj)LEVEL) == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    public void b(@Nonnull amu world, @Nonnull et pos, @Nonnull awt state, @Nonnull Random rand) {
        int quantaRemaining = this.quantaPerBlock - (Integer)state.c((axj)LEVEL);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int adjacentSourceBlocks = 0;
            if (ForgeEventFactory.canCreateFluidSource(world, pos, state, this.canCreateSources)) {
                for (Object side : fa.c.a) {
                    if (!this.isSourceBlock((amy)world, pos.a((fa)side))) continue;
                    ++adjacentSourceBlocks;
                }
            }
            if (adjacentSourceBlocks >= 2 && (world.o(pos.b(this.densityDir)).a().a() || this.isSourceBlock((amy)world, pos.b(this.densityDir)))) {
                expQuanta = this.quantaPerBlock;
            } else if (this.hasVerticalFlow((amy)world, pos)) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                for (fa side : fa.c.a) {
                    maxQuanta = this.getLargerQuanta((amy)world, pos.a(side), maxQuanta);
                }
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.g(pos);
                } else {
                    world.a(pos, state.a((axj)LEVEL, (Comparable)Integer.valueOf(this.quantaPerBlock - expQuanta)), 2);
                    world.a(pos, (aow)this, this.tickRate);
                    world.b(pos, (aow)this, false);
                }
            }
        }
        if (this.canDisplace((amy)world, pos.b(this.densityDir))) {
            this.flowIntoBlock(world, pos.b(this.densityDir), 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((amy)world, pos) || !this.isFlowingVertically((amy)world, pos)) {
            if (this.hasVerticalFlow((amy)world, pos)) {
                flowMeta = 1;
            }
            boolean[] flowTo = this.getOptimalFlowDirections(world, pos);
            for (int i2 = 0; i2 < 4; ++i2) {
                if (!flowTo[i2]) continue;
                this.flowIntoBlock(world, pos.a(SIDES.get(i2)), flowMeta);
            }
        }
    }

    protected final boolean hasDownhillFlow(amy world, et pos, fa direction) {
        return world.o(pos.a(direction).c(this.densityDir)).u() == this && (this.canFlowInto(world, pos.a(direction)) || this.canFlowInto(world, pos.c(this.densityDir)));
    }

    public boolean isFlowingVertically(amy world, et pos) {
        return world.o(pos.b(this.densityDir)).u() == this || world.o(pos).u() == this && this.canFlowInto(world, pos.b(this.densityDir));
    }

    public boolean isSourceBlock(amy world, et pos) {
        awt state = world.o(pos);
        return state.u() == this && (Integer)state.c((axj)LEVEL) == 0;
    }

    protected boolean[] getOptimalFlowDirections(amu world, et pos) {
        for (int side = 0; side < 4; ++side) {
            this.flowCost[side] = 1000;
            et pos2 = pos.a(SIDES.get(side));
            if (!this.canFlowInto((amy)world, pos2) || this.isSourceBlock((amy)world, pos2)) continue;
            this.flowCost[side] = this.canFlowInto((amy)world, pos2.b(this.densityDir)) ? 0 : this.calculateFlowCost(world, pos2, 1, side);
        }
        int min = Ints.min((int[])this.flowCost);
        for (int side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(amu world, et pos, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            et pos2;
            if (SIDES.get(adjSide) == SIDES.get(side).d() || !this.canFlowInto((amy)world, pos2 = pos.a(SIDES.get(adjSide))) || this.isSourceBlock((amy)world, pos2)) continue;
            if (this.canFlowInto((amy)world, pos2.b(this.densityDir))) {
                return recurseDepth;
            }
            if (recurseDepth >= this.quantaPerBlock / 2) continue;
            cost = Math.min(cost, this.calculateFlowCost(world, pos2, recurseDepth + 1, adjSide));
        }
        return cost;
    }

    protected void flowIntoBlock(amu world, et pos, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, pos)) {
            world.a(pos, this.t().a((axj)LEVEL, (Comparable)Integer.valueOf(meta)));
        }
    }

    protected boolean canFlowInto(amy world, et pos) {
        return world.o(pos).u() == this || this.canDisplace(world, pos);
    }

    protected int getLargerQuanta(amy world, et pos, int compare) {
        int quantaRemaining = this.getEffectiveQuanta(world, pos);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public int place(amu world, et pos, @Nonnull FluidStack fluidStack, boolean doPlace) {
        if (fluidStack.amount < 1000) {
            return 0;
        }
        if (doPlace) {
            FluidUtil.destroyBlockOnFluidPlacement(world, pos);
            world.a(pos, this.t(), 11);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(amu world, et pos, boolean doDrain) {
        if (!this.isSourceBlock((amy)world, pos)) {
            return null;
        }
        if (doDrain) {
            world.g(pos);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(amu world, et pos) {
        return this.isSourceBlock((amy)world, pos);
    }
}

