/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.inventory.ingredient;

import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IngredientFluidStack;
import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IngredientItemStack;
import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IngredientItemStackNBT;
import com.alcatrazescapee.alcatrazcore.inventory.ingredient.IngredientOreDict;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public interface IRecipeIngredient
extends Predicate<Object> {
    public static IRecipeIngredient of(ItemStack stack) {
        return new IngredientItemStack(stack);
    }

    public static IRecipeIngredient of(String oreName) {
        return new IngredientOreDict(oreName);
    }

    public static IRecipeIngredient of(String oreName, int amount) {
        return new IngredientOreDict(oreName, amount);
    }

    public static IRecipeIngredient of(Fluid fluid, int amount) {
        return new IngredientFluidStack(fluid, amount);
    }

    public static IRecipeIngredient of(FluidStack stack) {
        return new IngredientFluidStack(stack);
    }

    public static IRecipeIngredient of(ItemStack stack, boolean useNBT) {
        return useNBT ? new IngredientItemStackNBT(stack) : IRecipeIngredient.of(stack);
    }

    @Nonnull
    public String getName();

    @Nonnull
    public List<ItemStack> getStacks();

    @Override
    public boolean test(Object var1);

    default public boolean testIgnoreCount(Object input) {
        return this.test(input);
    }

    public boolean matches(IRecipeIngredient var1);
}

