/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.api;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import xzeroair.trinkets.capabilities.Capabilities;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;
import xzeroair.trinkets.capabilities.Trinket.TrinketProperties;
import xzeroair.trinkets.capabilities.race.EntityProperties;
import xzeroair.trinkets.traits.AbilityHandler;
import xzeroair.trinkets.traits.abilities.interfaces.IAbilityInterface;
import xzeroair.trinkets.util.TrinketsConfig;

public class TrinketHelper {
    public static ITrinketContainerHandler getTrinketHandler(EntityPlayer player) {
        ITrinketContainerHandler handler = (ITrinketContainerHandler)player.getCapability(TrinketContainerProvider.containerCap, null);
        handler.setPlayer((EntityLivingBase)player);
        return handler;
    }

    public static boolean AccessoryCheck(EntityLivingBase player, Item item) {
        if (TrinketHelper.TrinketCheck(player, item)) {
            return true;
        }
        return TrinketHelper.baubleCheck(player, item);
    }

    public static boolean AccessoryCheck(EntityLivingBase player, List<Item> items) {
        boolean found = false;
        for (Item item : items) {
            if (!TrinketHelper.AccessoryCheck(player, item)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean TrinketCheck(EntityLivingBase player, Item item) {
        ITrinketContainerHandler Trinket;
        if (player instanceof EntityPlayer && item != null && (Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)player)) != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                if (Trinket.getStackInSlot(i).func_190926_b() || !Trinket.getStackInSlot(i).func_77973_b().func_77658_a().contentEquals(item.func_77658_a())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean baubleCheck(EntityLivingBase player, Item item) {
        IBaublesItemHandler baubles2;
        if (Loader.isModLoaded((String)"baubles") && player instanceof EntityPlayer && item != null && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player))) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                if (baubles2.getStackInSlot(i).func_190926_b() || !baubles2.getStackInSlot(i).func_77973_b().func_77658_a().contentEquals(item.func_77658_a())) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getAccessory(EntityPlayer player, Item item) {
        IBaublesItemHandler baubles2;
        boolean skip = false;
        ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler(player);
        if (Trinket != null) {
            for (int i = 0; i < Trinket.getSlots(); ++i) {
                if (Trinket.getStackInSlot(i).func_190926_b() || !Trinket.getStackInSlot(i).func_77973_b().func_77658_a().contentEquals(item.func_77658_a())) continue;
                skip = true;
                return Trinket.getStackInSlot(i);
            }
        }
        if (Loader.isModLoaded((String)"baubles") && !skip && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player)) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                if (baubles2.getStackInSlot(i).func_190926_b() || !baubles2.getStackInSlot(i).func_77973_b().func_77658_a().contentEquals(item.func_77658_a())) continue;
                return baubles2.getStackInSlot(i);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getBaubleStack(EntityPlayer player, Item item) {
        IBaublesItemHandler baubles2;
        if (Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player)) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                if (baubles2.getStackInSlot(i).func_190926_b() || baubles2.getStackInSlot(i).func_77973_b() != item) continue;
                return baubles2.getStackInSlot(i);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getItemStackFromSlot(EntityLivingBase player, int slot, int handler) {
        if (player instanceof EntityPlayer && slot >= 0) {
            IBaublesItemHandler baubles2;
            if (handler == 1) {
                ITrinketContainerHandler Trinket = TrinketHelper.getTrinketHandler((EntityPlayer)player);
                if (!Trinket.getStackInSlot(slot).func_190926_b()) {
                    return Trinket.getStackInSlot(slot);
                }
            } else if (Loader.isModLoaded((String)"baubles") && handler == 2 && !(baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)((EntityPlayer)player))).getStackInSlot(slot).func_190926_b()) {
                return baubles2.getStackInSlot(slot);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static NBTTagCompound getTagCompoundSafe(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static Map<Integer, ItemStack> getEquippedBaubles(Map<Integer, ItemStack> map, EntityPlayer player) {
        IBaublesItemHandler baubles2;
        if (Loader.isModLoaded((String)"baubles") && player != null && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player)) != null) {
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                TrinketProperties prop = Capabilities.getTrinketProperties(stack);
                if (map.get(i) == null) {
                    if (prop != null) {
                        prop.itemEquipped((EntityLivingBase)player, i, 2);
                    }
                    map.put(i, stack);
                    continue;
                }
                ItemStack oldStack = map.get(i);
                if (oldStack.func_185136_b(stack)) continue;
                TrinketProperties oldProp = Capabilities.getTrinketProperties(oldStack);
                if (oldProp != null) {
                    oldProp.itemUnequipped((EntityLivingBase)player);
                }
                if (prop != null) {
                    prop.itemEquipped((EntityLivingBase)player, i, 2);
                }
                map.replace(i, stack);
            }
        }
        return map;
    }

    public static Map<Integer, ItemStack> getEquippedTrinkets(Map<Integer, ItemStack> map, EntityPlayer player) {
        ITrinketContainerHandler trinkets2;
        if (TrinketsConfig.SERVER.GUI.guiEnabled && player != null && (trinkets2 = TrinketHelper.getTrinketHandler(player)) != null) {
            for (int i = 0; i < trinkets2.getSlots(); ++i) {
                ItemStack stack = trinkets2.getStackInSlot(i);
                TrinketProperties prop = Capabilities.getTrinketProperties(stack);
                if (map.get(i) == null) {
                    if (prop != null) {
                        prop.itemEquipped((EntityLivingBase)player, i, 2);
                    }
                    map.put(i, stack);
                    continue;
                }
                ItemStack oldStack = map.get(i);
                if (oldStack.func_185136_b(stack)) continue;
                TrinketProperties oldProp = Capabilities.getTrinketProperties(oldStack);
                if (oldProp != null) {
                    oldProp.itemUnequipped((EntityLivingBase)player);
                }
                if (prop != null) {
                    prop.itemEquipped((EntityLivingBase)player, i, 2);
                }
                map.replace(i, stack);
            }
        }
        return map;
    }

    public static Map<String, ItemStack> getEquippedList(Map<String, ItemStack> map, EntityPlayer player) {
        ITrinketContainerHandler trinkets2;
        ItemStack stack;
        int i;
        IBaublesItemHandler baubles2;
        if (player == null) {
            return map;
        }
        String record = "";
        if (Loader.isModLoaded((String)"baubles") && (baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player)) != null) {
            for (i = 0; i < baubles2.getSlots(); ++i) {
                record = "baubles:" + i;
                stack = baubles2.getStackInSlot(i);
                if (map.get(record) == null) {
                    map.put(record, stack);
                    continue;
                }
                ItemStack oldStack = map.get(record);
                if (oldStack.func_185136_b(stack)) continue;
                map.replace(record, stack);
            }
        }
        if ((trinkets2 = TrinketHelper.getTrinketHandler(player)) != null) {
            for (i = 0; i < trinkets2.getSlots(); ++i) {
                record = "trinkets:" + i;
                stack = trinkets2.getStackInSlot(i);
                map.putIfAbsent(record, stack);
                if (map.get(record).func_185136_b(stack)) continue;
                map.replace(record, stack);
            }
        }
        return map;
    }

    public static boolean entityHasAbility(IAbilityInterface ability, EntityLivingBase entity) {
        AbilityHandler abilityHandler;
        EntityProperties properties;
        if (entity.hasCapability(Capabilities.ENTITY_RACE, null) && (properties = Capabilities.getEntityRace((Entity)entity)) != null && (abilityHandler = properties.getAbilityHandler()) != null) {
            return abilityHandler.hasAbility(ability);
        }
        return false;
    }
}

