/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.capabilities;

import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.nbt.NBTTagCompound;
import xzeroair.trinkets.capabilities.ITrinketCapability;
import xzeroair.trinkets.util.Reference;
import xzeroair.trinkets.util.handlers.TickHandler;

public abstract class CapabilityBase<T, E>
implements ITrinketCapability<T> {
    protected Random random = Reference.random;
    protected Map<String, TickHandler> Counters;
    protected NBTTagCompound tag;
    protected E object;

    public CapabilityBase(E object) {
        this.object = object;
        this.Counters = new TreeMap<String, TickHandler>();
    }

    public NBTTagCompound getTag() {
        if (this.tag == null) {
            this.tag = new NBTTagCompound();
        }
        return this.tag;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void saveToNBT(NBTTagCompound tag) {
    }

    @Override
    public void loadFromNBT(NBTTagCompound tag) {
    }

    @Override
    public void copyFrom(T capability, boolean wasDeath, boolean keepInv) {
    }

    public void addCounter(String key, int length) {
        if (this.Counters != null && !this.Counters.containsKey(key)) {
            this.Counters.put(key, new TickHandler(key, length));
        }
    }

    public void removeCounter(String key) {
        if (!this.Counters.isEmpty() && this.Counters.containsKey(key)) {
            this.Counters.remove(key);
        }
    }

    public void clearCounters() {
        if (!this.Counters.isEmpty()) {
            this.Counters.clear();
        }
    }

    public TickHandler getCounter(String key, int length, boolean isCountdown, boolean create) {
        if (!this.Counters.isEmpty() && this.Counters.containsKey(key)) {
            return this.Counters.get(key);
        }
        if (create) {
            TickHandler value = new TickHandler(key, length, isCountdown);
            this.Counters.put(key, value);
            return value;
        }
        return null;
    }

    public TickHandler getCounter(String key, int length, boolean isCountdown) {
        return this.getCounter(key, length, isCountdown, true);
    }

    public TickHandler getCounter(String key, boolean create) {
        return this.getCounter(key, 20, false, create);
    }

    public TickHandler getCounter(String key) {
        return this.getCounter(key, false);
    }
}

